#!/bin/bash
#
#  geom_replace.sh


echo
echo  "   *****  For  EXTERNAL POWER SUPPLY  PCB  Only  *****"
echo  "              -----------------------"
echo  "This program will ask the user for the filename of"
echo  "an ASCII Geometry, then it will call the Mentor"
echo  "Librarian to Replace that Geometry,  i.e. to update"
echo  "Mentor's internal version of that geometry".
echo
echo  "      *****  External_Power_Supply  Version  *****"

#
#  First setup a variable that is the path to
#  the directory that holds the ASCII Geometry
#  source files.
#

Geom_File_Path=/home2/designs/boards/Ext_PS/Work/Geometries/


#
#  And setup the name of a log file that will hold
#  the results of the Mentor Librarian operation.
#

Lib_Log_File="$Geom_File_Path"librarian_geometry_replace_log.txt


#  Now get the filename of the ASCII Geometry
#  that you want the Librarian program to Replace.

echo
echo  "Enter just the filename of the ASCII Geometry"
echo  "that you want Mentor Librarian to Replace"
echo

echo  -n  "Enter the Filename of the Geometry to Replace:  "

read  Geom_File_to_Replace

Full_Geom_File_Name=$Geom_File_Path$Geom_File_to_Replace


#
#  Test to verify that this file exists.  If this ASCII
#  Geometry source files exits then call the Mentor
#  Librarian to Replace it.  If this file does not exist
#  then output a warning message and exit with an error
#  status of 1.    Note that after this file test that
#  the "then" section goes on for a long time.  The "fi"
#  section is way down the page.
#


if [ -e  "$Full_Geom_File_Name" ]

then

echo
echo
echo  "Librarian will Replace  $Full_Geom_File_Name"
echo
echo


#
#  Now run the Mentor Librarian program in the  nodisplay  mode.
#
#  - Direct the standard output from Librarian to a log file named
#    librarian_geometry_replace_log.txt   This file will be written
#    in the directory that holds the ASCII Geometry source files.
#
#  - Send command line arguments to Librarian from a "here document"
#    code block that is limited by the string "EOF".
#
#  - Note that the back slash \  that starts the  restore  line
#    and the  save  line.  The back slash is needed to escape
#    the special meaning of the $ that starts each of these lines.
#    In these two cases we do not want the $ character to
#    cause variable substitution to take place.  These
#    two $ are just part of the syntax that the Mentor
#    Librarian program expects.
#


librarian  /home2/designs/boards/Ext_PS/Ext_PS_Brd  -nodisplay  > "$Lib_Log_File"  <<EOF


\$restore_ascii_geometries("$Full_Geom_File_Name", @replace);


\$save_geometries("", @noreplace, @design);


\$close_session(@discard);


EOF


echo
echo  "Mentor Librarian has run."
echo


#
#  Now scan the log file that was written by Mentor
#  Librarian to see if there have been any errors.
#  If there are any errors noted in the Librarian
#  log file then warn the user.
#

#  bla  bla  bla

exit 0

#
#  This now ends the "then" section from the test
#  to see if the ascii geometry source file existed.
#


fi


#
#  If we are executing the following it means that
#  the given ascii geometry source file does not exit.
#

echo
echo  "The given file name does not exist in the"
echo  "directory that holds the ASCII Geom source files."
echo

exit 1



