#include "D0RunIIConeFinder.hh"
#include "JetCore/CommonUtils.hh"
#include <vector>
#include "ILConeAlgorithm.hh"
#include <iostream>
namespace SpartyJet { 

namespace D0 {

  void D0RunIIConeFinder::configure(bool sp,float cr,float mje,float sr,float fr,
				    float emr,bool kd,float ddr,float ddpt,float sf,
				    float pmlp,float pmsp,int mm,float pmn,float iet,float zv) {
    cone_radius              = cr;
    min_jet_Et               = mje;
    split_ratio              = sr;
    far_ratio                = fr;
    Et_min_ratio             = emr;
    kill_duplicate           = kd;
    duplicate_dR             = ddr; 
    duplicate_dPT            = ddpt; 
    search_factor            = sf;
    pT_min_leading_protojet  = pmlp;
    pT_min_second_protojet   = pmsp;
    merge_max                = mm;
    pT_min_nomerge           = pmn;
    
    Item_ET_Threshold        = iet;
    Zvertex                  = zv;

    do_second_pass           = sp;
    init();
  }
  
  void D0RunIIConeFinder::init(JetMomentMap *mmap) {

    if(savePassNum && mmap != NULL) {
      mmap->schedule_jet_moment("pass_num");
    }
  }
  
  void D0RunIIConeFinder::execute(JetCollection &inputJets) {

    std::list<const Jet*> towers;
    std::list<const Jet*> towers2;
    std::vector<Jet*> jets;
    std::vector<Jet*> jets2;

    // retrieve the map of the collection :
    JetMomentMap * themap = inputJets.get_JetMomentMap();
    if (savePassNum && (themap->num_jet_moment() ==0)) return;

    
    // retrieve position of moment in map
    int pass_num_pos = 0;
    if(savePassNum) pass_num_pos = themap->get_jet_momentPos("pass_num");
    unsigned last_first_pass;
    
    //convert JetCollection to std::list<const Jet*>
  	JetCollection::iterator iter = inputJets.begin();
  	Jet *tjet = NULL;
  	const Jet* ptr;
		int ind=0;
		while(iter != inputJets.end()){
    	tjet = *iter;
			ptr = new Jet(tjet->px(),tjet->py(),tjet->pz(),tjet->E(),ind);
			towers.push_back(ptr);
			++iter; ++ind;
    }

    // run the algorithm

    ILConeAlgorithm d0m(cone_radius, min_jet_Et, split_ratio,
			     far_ratio, Et_min_ratio, kill_duplicate, duplicate_dR, 
			     duplicate_dPT, search_factor, pT_min_leading_protojet, 
			     pT_min_second_protojet, merge_max, pT_min_nomerge);
    
    d0m.makeClusters(jets, towers, Item_ET_Threshold,inputJets);
    
    std::vector<Jet*>::iterator clusteriter;
    last_first_pass = jets.size();
    
    // run second pass if turned on
    if(do_second_pass) {
      towers2 = towers;
      
      // loop over constituents of all jets and remove from towers2
      std::vector<Jet*>::iterator jetIter = jets.begin();
      bool found;
      for( ; jetIter != jets.end(); jetIter++) {

	Jet::constit_vect_t::iterator rtowerIter = (*jetIter)->firstConstituent();
	for( ; rtowerIter != (*jetIter)->lastConstituent(); rtowerIter++) {
	  int index = (*rtowerIter)->index();

	  found = false;
	  std::list<const Jet*>::iterator toremove = towers2.begin();
	  for( ; toremove != towers2.end(); toremove++){
	    if((*toremove)->index()== index ) {
	      towers2.erase(toremove);
	      found = true;
	    }
	    if(found == true) break;
	  }
	}
      } // all towers that were found in first pass jets are now removed from towers2

      // do a second pass with remaining towers
      d0m.makeClusters(jets2,towers2,Item_ET_Threshold,inputJets);
      
      // combine jets2 and jets;
      clusteriter = jets2.begin();
      for( ; clusteriter != jets2.end(); clusteriter++)
	jets.push_back(*clusteriter);
    }
    
    // set jet moment "pass_num"
    if(savePassNum) {
      unsigned cnum = 0;
      clusteriter = jets.begin();
      for( ; clusteriter != jets.end(); clusteriter++) {
	
    	if(cnum < last_first_pass)
    	  themap->set_jet_moment(pass_num_pos,*clusteriter,1);   // first pass jet
    	else
    	  themap->set_jet_moment(pass_num_pos,*clusteriter,2);   // second pass jet

	cnum++;
      }
    }
    
    // we can now delete the input collection :
    clear_list(inputJets);
    // and update it :
    //inputJets.swap(jets)
    std::vector<Jet*>::iterator xit  = jets.begin();
    std::vector<Jet*>::iterator xitE = jets.end();
    Jet* ijet;
    for(; xit != xitE; xit++) {
      ijet = *xit;
      inputJets.push_back(ijet);
    }
    
    if(towers.size() > 0) {
      int initial_size = towers.size();
      for(int i = 0; i < initial_size;i++) {
        const Jet* temp = *towers.begin();
        towers.erase(towers.begin());
        delete temp;
      }
    }

  }
  

}  // namespace SpartyJet
}
