#ifndef _DORUNIICONEFINDER_HH_
#define _DORUNIICONEFINDER_HH_

#include "JetCore/JetTool.hh"
#include <string>
namespace SpartyJet { 

class JetMomentMap;
namespace D0 {

class D0RunIIConeFinder : public JetTool {
public :
  D0RunIIConeFinder(std::string name = "myD0cone",bool sp = false) {
    cone_radius              = 0.5;
    min_jet_Et               = 0.0;
    split_ratio              = 0.5;
    far_ratio                = 0.5;
    Et_min_ratio             = 0.5;
    kill_duplicate           = true;
    duplicate_dR             = 0.005; 
    duplicate_dPT            = 0.01; 
    search_factor            = 1.0; 
    pT_min_leading_protojet  = 0.0; 
    pT_min_second_protojet   = 0.0;
    merge_max                = 10000; 
    pT_min_nomerge           = 0.0;

    Item_ET_Threshold        = 0.0;
    Zvertex                  = 0.0;

    savePassNum              = sp;
    set_second_pass(sp);
    m_name = name;
    init();
  };

  void configure(bool,float,float,float,float,float,bool,float,float,float,
		 float,float,int,float,float,float);
  void set_second_pass(bool x)           {do_second_pass   = x;}
  void set_name(std::string n)           {m_name = n;}
  void set_savePassNum(bool x)           {savePassNum      = x;}

  void set_coneRadius(float x)           {cone_radius      = x;}
  void set_minJetEt(float x)             {min_jet_Et       = x;}
  void set_splitRatio(float x)           {split_ratio      = x;}
  void set_farRatio(float x)             {far_ratio        = x;}
  void set_EtMinRatio(float x)           {Et_min_ratio     = x;}
  void set_killDuplicate(bool x)         {kill_duplicate   = x;}
  void set_duplicate_dR(float x)         {duplicate_dR     = x;}
  void set_duplicate_dPT(float x)        {duplicate_dPT    = x;}
  void set_searchFactor(float x)         {search_factor    = x;}
  void set_pTMinLeadingProtojet(float x) {pT_min_leading_protojet = x;}
  void set_pTMinSecondProtojet(float x)  {pT_min_second_protojet  = x;}
  void set_mergeMax(int x)               {merge_max        = x;}
  void set_pTMinNoMerge(float x)         {pT_min_nomerge   = x;}
  void set_itemEtThreshold(float x)      {pT_min_nomerge   = x;}
  void set_Zvertex(float x)              {Zvertex          = x;}
  double getConeRadius()                 {return cone_radius;}

  virtual void init(JetMomentMap *mmap=0);
  virtual void execute(JetCollection &inputJets);

protected:
  
  bool  savePassNum;
  bool  do_second_pass;

  float cone_radius;
  float min_jet_Et;
  float split_ratio;
  float far_ratio;
  float Et_min_ratio;
  bool  kill_duplicate;
  float duplicate_dR; 
  float duplicate_dPT; 
  float search_factor; 
  float pT_min_leading_protojet; 
  float pT_min_second_protojet;
  int   merge_max; 
  float pT_min_nomerge;

  float Item_ET_Threshold;
  float Zvertex;
};

}

}  // namespace SpartyJet
#endif
