#include "CalchepPartonTextInput.hh"
#include <iostream>
#include <string>
#include <cmath>

// this is to avoid a gcc 3.2.3 problem
char* operator+( std::streampos&, char* );
namespace SpartyJet { 

void CalchepPartonTextInput::init(std::string filename) {
  unitIsGeV(); // SpartyJet default
  file = NULL;
  if(file != NULL)
    delete file;
  file = new ifstream(filename.c_str());

  m_currentEvnt = 0;
  num_in_particles = 0;
  num_fin_particles = 0;
  m_filename = filename;
  if(!file->is_open())
    m_log << ERROR << "CalchepPartonTextInput file " << filename << " did not open correctly!\n";
}

void CalchepPartonTextInput::fillInput(int eventn, Jet::jet_list_t &inputList) {
  moveToEventN(eventn);
  fillNextInput(inputList);
}

bool CalchepPartonTextInput::fillNextInput(Jet::jet_list_t &inputList,int start_index) {
  double px,py,pz,E;
  double dummy;
  std::string word;   // dummy string variable

  inputList.clear();
  
  *file >> dummy;      // get rid of the "Event" number
  for(int in = 0; in < num_in_particles; in++)
    *file >> dummy;
  for(int fin = 0; fin < num_fin_particles; fin++) {
    px = py = pz = -1;
    *file >> px >> py >> pz;
    if(px == -1 && py == -1 && pz == -1)
      return false;
    E = sqrt(px*px + py*py + pz*pz + mass[fin]*mass[fin]);
    Jet* j = new Jet(px,py,pz,E);
    if(!m_reject_bad_input || InputMaker::check_4vector(j) ) inputList.push_back(j);
  }
  getline(*file,word);
  
  if(inputList.size() > 0 && num_fin_particles) {         // event found with some jets
    m_currentEvnt++;
    return true;
  }
  else return false;                                         // no event found
}

void CalchepPartonTextInput::moveToEventN(int n) {

  init(m_filename);                  // start from beginning of file
  
  char peek;
  m_currentEvnt = 0;
  std::string word;    // dummy variable
  double tempmass;
  bool end = false;

	do {
		peek = file->peek();
		if(peek == 35) {
			file->get();
			peek = file->peek();
			if(peek == 'T') {
				*file >> word;
				*file >> num_in_particles;
				*file >> word;
				*file >> num_fin_particles;
				if(num_fin_particles <=0)
					m_log << WARNING << "Number of final state particles invalid." << std::endl;
			}
			else if(peek == 'M') {   // assuming num_particles is already set, as it should be
				*file >> word;
				for(int in = 0; in < num_in_particles; in++)
					*file >> tempmass;
				for(int fin = 0; fin < num_fin_particles; fin++) {
					*file >> tempmass;
					mass.push_back(tempmass);
				}
			}
			else if(peek == 'N') {
				*file >> word;
				*file >> m_totalEvntN;
			}
			else if(peek == 'E') {
				getline(*file,word);
				m_currentEvnt = 0;
				for(int i = 0; i < n; i++) {

					getline(*file,word);
					m_currentEvnt++;
				}
				end = true;
			}
			else getline(*file,word);
		}
		else getline(*file,word);
	} while(*file && !end);
}

}  // namespace SpartyJet
