#ifndef _CALCHEPPARTONTEXT_INPUT_HH_
#define _CALCHEPPARTONTEXT_INPUT_HH_

#include "JetCore/InputMaker.hh"
namespace SpartyJet { 

class CalchepPartonTextInput : public TextInputMaker {
public:

  CalchepPartonTextInput() : TextInputMaker() {
    m_filename = "";
    m_currentEvnt = 0;
    m_name = "CalchepInput";
		m_log.set_name(name());
  }
  CalchepPartonTextInput(std::string filename) : TextInputMaker() {
    m_currentEvnt = 0;
    m_name = "CalchepInput";
		m_log.set_name(name());
    m_filename = filename; 
    init(filename);
  }

  virtual ~CalchepPartonTextInput() {};

  virtual void init(std::string filename);
  virtual void fillInput(int eventn, Jet::jet_list_t &inputList);
  virtual bool fillNextInput(Jet::jet_list_t &inputList,int start_index=0);
  virtual void moveToEventN(int n);

protected:
  int num_in_particles;
  int num_fin_particles;
  std::vector<double> mass;
  int m_totalEvntN;
};

}  // namespace SpartyJet
#endif
