#ifndef _JETMESSAGE_HH_
#define _JETMESSAGE_HH_
///////////////////////////////////////
//
// A very basic logging system
//
//
///////////////////////////////////////

#include <string>
#include <iostream>
#include <sstream>

namespace SpartyJet { 

enum MessageLevel {DEBUG=1, INFO, WARNING, ERROR};
static std::string msgLevelStr[4] = {"DEBUG", "INFO", "WARNING", "ERROR"};

class Message {
public:
  Message() : m_name("") {m_level = INFO;};
  Message(std::string s) {m_level = INFO; set_name(s); };
  
	
  void set_name(std::string name){ 
		m_name=name;
		}

  static void silent_all()											{g_level = ERROR;}
	static void set_message_level(MessageLevel l)	{g_level = l;}
	static MessageLevel get_message_level()				{return g_level;}

  template<class T>
  Message& operator<<( T o){
    if(m_level < g_level ){
      return (*this);
    }
    m_buff << o;
    return (*this);
  }

  Message& operator<<( MessageLevel m){ 
    m_level=m;
    return (*this);
  }

  typedef std::ostream& (endl_t)(std::ostream &) ;
  Message& operator<<( endl_t& e){ // detect endl. certainly there is
				   // better to be done !
    if(m_level < g_level )  return *this;
		std::cout.width(20);
		std::cout << std::left << m_name;
    std::cout.width(10);
    std::cout << std::left << msgLevelStr[(int)m_level-1];
		std::cout << std::left << m_buff.str() << std::endl;
		m_buff.str("");
    
		//m_buff << std::left << m_name;
    return (*this);
  }

  //const static int mwidth = 20;
  static MessageLevel g_level;
protected:

  std::string m_name;
  MessageLevel m_level;  
  
  std::ostringstream  m_buff;

};

inline static MessageLevel GlobalLevel() {return Message::g_level;}
}  // namespace SpartyJet
#endif
