#include "GetJets.hh"
#include "JetMomentMap.hh"

namespace SpartyJet {

  // need to turn off all comments from JetAlgorithm yet

  JetCollection getjets(JetTool* tool,
			   Jet::jet_list_t& inputJets) {
    
    // first create a JetAlgorithm and add the jet tool
    JetAlgorithm alg;
    alg.make_silent();
    alg.addTool(tool);
    alg.init();

    JetCollection outputJets;
    
    alg.execute(inputJets,outputJets);
    
    return outputJets;
  }

  std::vector<TLorentzVector> getjets(JetTool* tool,
				      std::vector<TLorentzVector>& input) {
    
    std::vector<TLorentzVector> output;
    SpartyJetTool sparty;
    output = sparty.getjets(tool,input);
    return output;
  }

  std::vector<simplejet> getjets(JetTool* tool,
				 std::vector<simplejet>& input) {    

    std::vector<simplejet> output;
    SpartyJetTool sparty;
    output = sparty.getjets(tool,input);
    return output;
  }

  std::vector<TLorentzVector> getjets(JetTool* tool,
				      std::vector<TLorentzVector>& input,
				      std::vector<std::vector<int> >& constituents) {

    std::vector<TLorentzVector> output;
    SpartyJetTool sparty;
    output = sparty.getjets(tool,input,constituents);
    return output;
  }



  // ********************************************************************
  // New tool
  // ********************************************************************

void SpartyJetTool::init_jetAlg(JetTool *tool){
  
  if(m_alg) {
    delete m_alg;
    m_alg = 0;
  }
  m_alg = new JetAlgorithm();
  m_alg->make_silent();

  std::vector<JetTool *>::iterator it=m_frontTools.begin();
  // add front tools :
  for(; it != m_frontTools.end(); ++it){
    m_alg->addTool(*it);
  }
  m_alg->addTool(tool);
  // add back tools :
  it=m_frontTools.begin();
  for(; it != m_frontTools.end(); ++it){
    m_alg->addTool(*it);
  }


  m_alg->init();    
}

  void SpartyJetTool::add_tool(JetTool * tool, bool beforeFinder){ 
    if(beforeFinder)   m_frontTools.push_back(tool);
    else m_backTools.push_back(tool);
}

void SpartyJetTool::remove_tool(JetTool * tool){
  std::vector<JetTool *>::iterator it = m_frontTools.begin();
  while(it != m_frontTools.end() ){
    if( *it == tool) {
      m_frontTools.erase(it);
      break;
    }
    it++;
  }
  if( it !=  m_frontTools.end() ) return; // we found and removed the tool
  // search tool in the other tool list
  it = m_backTools.begin();
  while(it != m_backTools.end() ){
    if( *it == tool) {
      m_backTools.erase(it);
      break;
    }
    it++;
  }  
}

void SpartyJetTool::clear_additional_tools(bool do_delete){
  if(do_delete){
    std::vector<JetTool *>::iterator it=m_frontTools.begin();
    for(; it != m_frontTools.end(); ++it){
      delete *it;
    }
  }
  m_frontTools.clear();

  if(do_delete){
    std::vector<JetTool *>::iterator it=m_backTools.begin();
    for(; it != m_backTools.end(); ++it){
      delete *it;
    }
  }
  m_backTools.clear();
}


JetCollection SpartyJetTool::getjets(JetTool* tool,
				 Jet::jet_list_t& inputJets) {
  
  init_jetAlg(tool);
  JetCollection outputJets;
  m_alg->execute(inputJets,outputJets);
  
  return outputJets;
}

std::vector<TLorentzVector> SpartyJetTool::getjets(JetTool* tool,
					       std::vector<TLorentzVector>& input) {
  
  // convert input to Jet::jet_list_t
  Jet::jet_list_t inputJets;
  Jet* temp;
  for(unsigned i = 0; i < input.size(); i++) {
    temp = new Jet(input[i][0],input[i][1],input[i][2],input[i][3]);
    inputJets.push_back(temp);
  }
  
  init_jetAlg(tool);
  JetCollection outputJets;
  m_alg->execute(inputJets,outputJets);
  
  // convert outputJets back to vector<TLorentzVector>
  std::vector<TLorentzVector> output;
  for(unsigned i = 0; i < outputJets.size(); i++)
    output.push_back(TLorentzVector(outputJets[i]->px(),outputJets[i]->py(),
				    outputJets[i]->pz(),outputJets[i]->E()));
  
  clear_list(outputJets);
  clear_list(inputJets);
  
  return output;
}

std::vector<simplejet> SpartyJetTool::getjets(JetTool* tool,
							 std::vector<simplejet>& input) {    
  
  // convert input to Jet::jet_list_t
  Jet::jet_list_t inputJets;
  Jet* temp;
  int num = 0;
  for(unsigned i = 0; i < input.size(); i++) {
    temp = new Jet(input[i].jet[0],input[i].jet[1],input[i].jet[2],input[i].jet[3],num);
    inputJets.push_back(temp);
    num++;
  }
  
  init_jetAlg(tool);
  JetCollection outputJets;
  m_alg->execute(inputJets,outputJets);

  JetMomentMap * moment_map = outputJets.get_JetMomentMap();
  // convert outputJets back to vector<TLorentzVector>
  std::vector<simplejet> output;
  simplejet tempsimplejet;
  TLorentzVector* temp2;
  for(unsigned i = 0; i < outputJets.size(); i++) {
    temp2 = new TLorentzVector(outputJets[i]->px(),outputJets[i]->py(),
			       outputJets[i]->pz(),outputJets[i]->E());
    
    // convert constituents to vector< vector<int> >
    tempsimplejet.constituents.clear();

//     tempsimplejet.area = outputJets[i]->area();
//     tempsimplejet.area_error = outputJets[i]->area_error();

    tempsimplejet.area = moment_map->get_jet_moment("area", outputJets[i]);
    tempsimplejet.area_error = moment_map->get_jet_moment("area_erro", outputJets[i]);
    
    TLorentzVector *consttemp;
    Jet::constit_vect_t::iterator citer  = outputJets[i]->firstConstituent();
    Jet *cjet;
    for(; citer != outputJets[i]->lastConstituent(); citer++) {
      cjet = *citer;
      consttemp = new TLorentzVector(cjet->px(),cjet->py(),cjet->pz(),cjet->E());
      tempsimplejet.constituents.push_back(*consttemp);
      delete consttemp;
    }
    
    tempsimplejet.jet = *temp2;
    output.push_back(tempsimplejet);
    delete temp2;
  }
  clear_list(outputJets);
  clear_list(inputJets);
  
  return output;
}

std::vector<TLorentzVector> SpartyJetTool::getjets(JetTool* tool,
					       std::vector<TLorentzVector>& input,
					       std::vector<std::vector<int> >& constituents) {
  
  // convert input to Jet::jet_list_t
  Jet::jet_list_t inputJets;
  Jet* temp;
  int num = 0;
  for(unsigned i = 0; i < input.size(); i++) {
    temp = new Jet(input[i][0],input[i][1],input[i][2],input[i][3],num);
    num++;
    inputJets.push_back(temp);
  }
  
  init_jetAlg(tool);
  JetCollection outputJets;
  m_alg->execute(inputJets,outputJets);
  
  // convert outputJets back to vector<TLorentzVector>
  std::vector<TLorentzVector> output;
  constituents.clear();
  for(unsigned i = 0; i < outputJets.size(); i++) {
    output.push_back(TLorentzVector(outputJets[i]->px(),outputJets[i]->py(),
				    outputJets[i]->pz(),outputJets[i]->E()));
    
    // convert constituents to vector< vector<int> >
    std::vector<int> tempvect;
    Jet::constit_vect_t::iterator citer  = outputJets[i]->firstConstituent();
    Jet *cjet;
    for(; citer != outputJets[i]->lastConstituent(); citer++) {
      cjet = *citer;
      tempvect.push_back(cjet->index());
    }
    constituents.push_back(tempvect);
  }
  clear_list(inputJets);
  clear_list(outputJets);
  
  return output;
}


}  // namespace SpartyJet
