#ifndef _GETJETS_HH_
#define _GETJETS_HH_

#include "JetCollection.hh"
#include "JetTool.hh"
#include "JetAlgorithm.hh"
#include "CommonUtils.hh"

#include <vector>
#include <list>
#include <TLorentzVector.h>




// old functions for backwards compatibility
namespace SpartyJet {

  struct simplejet {
    TLorentzVector jet;
    double area;
    double area_error;
    std::vector<TLorentzVector> constituents;
  };

  JetCollection getjets(JetTool* tool,Jet::jet_list_t& inputJets);
  std::vector<TLorentzVector> getjets(JetTool* tool,std::vector<TLorentzVector>&);
  std::vector<TLorentzVector> getjets(JetTool* tool,std::vector<TLorentzVector>&,std::vector<std::vector<int> >&);
  std::vector<SpartyJet::simplejet> getjets(JetTool* tool,std::vector<SpartyJet::simplejet>& input);


// new class
  class SpartyJetTool {
  public:
    SpartyJetTool(): m_alg(NULL){};
    ~SpartyJetTool() {if(m_alg) delete m_alg;}
    
    JetCollection                     getjets(JetTool* tool,Jet::jet_list_t& inputJets);
    std::vector<TLorentzVector>       getjets(JetTool* tool,std::vector<TLorentzVector>&);
    std::vector<TLorentzVector>       getjets(JetTool* tool,std::vector<TLorentzVector>&,std::vector<std::vector<int> >&);
    std::vector<SpartyJet::simplejet> getjets(JetTool* tool,std::vector<SpartyJet::simplejet>& input);
    
    void add_tool(JetTool * tool, bool beforeFinder = false);
    void remove_tool(JetTool * tool);
    void clear_additional_tools(bool do_delete = true );
    
  protected:
    JetAlgorithm * m_alg;
    void init_jetAlg(JetTool *tool);
    std::vector<JetTool *> m_frontTools;
    std::vector<JetTool *> m_backTools;
    
  };
  
}  // namespace SpartyJet
#endif
