#ifndef _GHOSTBUILDER_HH_
#define _GHOSTBUILDER_HH_

///////////////////////////////////////////
///
/// Defines some methods to add ghost proto-jets to 
/// a jet collection.
/// Could be purely random, on a grid, on a grid+random fluctuations...
///
////////////////////////////////////////////

#include "TRandom3.h"
#include "JetCollection.hh"
#include "JetMomentMap.hh"

namespace SpartyJet {

  class GhostBuilder {
  public:
    GhostBuilder(int n) : m_num(n) , m_phimin(-M_PI) , m_phimax(M_PI), m_rapmin(-5.), m_rapmax(5.) {}
    virtual ~GhostBuilder(){};
    
    virtual void add_ghosts(JetCollection* coll){};
    virtual void reconfigure(int nghosts, float rapmin, float rapmax, float phimin, float phimax){
      m_num = nghosts; m_phimin = phimin;m_phimax = phimax;
      m_rapmin = rapmin;m_rapmax = rapmax;
    };

  protected:
    int m_num;
    float m_phimin, m_phimax ;
    float m_rapmin, m_rapmax ;


  };


  class GhostBuilderRandom : public  GhostBuilder {
  public:
    GhostBuilderRandom(int n) : GhostBuilder(n) {}
    virtual ~GhostBuilderRandom(){};
    
    virtual void add_ghosts(JetCollection* coll){
      int index = coll->size();
	
	JetMomentMap * themap = coll->get_JetMomentMap();
	int pdgPos = themap->get_jet_momentPos("pdgId"); 

      for(int i=0;i<m_num;i++){
	double rap = rnd.Uniform(m_rapmin, m_rapmax);
	double phi = rnd.Uniform(m_phimin, m_phimax);
	Jet * j = new Jet(10e-16,0,0,10e-15,index);
	j->SetPtEtaPhiM(10e-16,rap, phi, 0);
	if(pdgPos!=-1) themap->set_jet_moment(pdgPos,j,0);
	coll->push_back(j);
	index++;
      }
    };
    
  protected:
    TRandom3 rnd;
  };

}


#endif
