#include "HepMCInput.hh"
#include <iostream>

// this is to avoid a gcc 3.2.3 problem
char* operator+( std::streampos&, char* );
namespace SpartyJet { 

	void HepMCInput::init(std::string filename) {
		if(file != NULL)
			delete file;
		file = new ifstream(filename.c_str());

		unitIsGeV(); // SpartyJet default

		m_currentEvnt = 0;
		m_filename = filename;
		invert = false;
		if(!file->is_open())
			m_log << ERROR << "HepMCInput file " << filename << " did not open correctly!" << std::endl;
	}

	void HepMCInput::init_collection(JetCollection &coll){
		coll.get_JetMomentMap()->schedule_jet_moment("pdgId");
	}

	void HepMCInput::fillInput(int eventn, Jet::jet_list_t &inputList, int start_index) {
		moveToEventN(eventn);
		fillNextInput(inputList, start_index);
	}

	bool HepMCInput::fillNextInput(Jet::jet_list_t &inputList, int start_index) {
		char peek;
		double px,py,pz,E,theta,phi,mass;
		int barcode,status,pdgid,endVtxBarcode,flow;
		bool end = false;
		int num_inserted=0;

		// check if we can get a moment map:
		JetCollection *coll = static_cast<JetCollection*>(&inputList); 
		JetMomentMap *map = 0;
		int pdgid_map_pos = -1;
		if(coll){
			map = coll->get_JetMomentMap();
			pdgid_map_pos = map->get_jet_momentPos("pdgId");
		}
		//-------------

		do {
			peek = file->peek();
			if(peek == 'E') {                                        // E - New Event
				file->ignore(1000,'\n'); 
				if(num_inserted > 0)
					end = true;
			} 
			else if(peek == 'P'){                                    // Particle Found
				peek = file->get(); // pull the P off the stream
				px = py = pz = E = -1;
				*file >> barcode >> pdgid >> px >> py >> pz >> E >> mass      // grab the rest of the information
					>> status >> theta >> phi >> endVtxBarcode >> flow;
				file->ignore(1000,'\n');                               // ignore anything else

				bool isStable = (status==1);
				//bool isParton = (status==22 || status==23); // ALPGEN
				bool isParton = (status>30 && status<44); // PYTHIA?


				if( ( (m_doParton && isParton) || (m_doStable && isStable) ) && px != -1 && py != -1 && pz != -1 && E != -1) 
				{
					Jet* j = new Jet(px,py,pz,E, num_inserted+start_index);
					if(!m_reject_bad_input || check_4vector(j) ) 
					{
						inputList.push_back(j);
						num_inserted++;
						if(map) map->set_jet_moment(pdgid_map_pos, j , pdgid); // add moment
					}
				}
			}
			else 
				file->ignore(1000,'\n');                            // must be a comment or nothing
		} while(*file && !end);
		if(num_inserted > 0) {                              // event found with some jets
			m_currentEvnt++;
			return true;
		}
		else return false;                                         // no event found
	}

	void HepMCInput::moveToEventN(int n) {
		if(n == m_currentEvnt) return;        // already happen to be at that event
		init(m_filename);                  // start from beginning of file
		if(m_currentEvnt == n) return;     // if n == 0, this is needed

		char peek;
		do {
			peek = file->peek();
			if(peek == 'E') {// Found beginning of new event 
				file->ignore(1000,'\n'); 
				m_currentEvnt++;
				if(m_currentEvnt == n) return;
			}
			else 
				file->ignore(1000,'\n');     // ignore anything else
		} while(*file);

		return;
	}

}  // namespace SpartyJet
