#ifndef _HEPMC_INPUT_HH_
#define _HEPMC_INPUT_HH_

// Class to read HepMC ascii files
// Format assumed to be consistent with HepMC 2.X
// as described here:
// http://lcgapp.cern.ch/project/simu/HepMC/20400/HepMC2_user_manual.pdf


#include "JetCore/InputMaker.hh"
namespace SpartyJet { 

class HepMCInput : public TextInputMaker {
public:

  HepMCInput() : TextInputMaker() {
    m_filename = "";
    m_currentEvnt = -1;
    invert = false;
    m_name = "HepMCinput";
		m_log.set_name(m_name);
		m_doStable = true;
		m_doParton = false;
  }
  HepMCInput(std::string filename) : TextInputMaker() {
    file = NULL;
    m_filename = filename; 
    init(filename);
    m_currentEvnt = 0;
    invert = false;
    m_name = "HepMCinput";
		m_log.set_name(m_name);
		m_doStable = true;
		m_doParton = false;
  }
  
	virtual ~HepMCInput() {};

  virtual void init(std::string filename);
  virtual void fillInput(int eventn, Jet::jet_list_t &inputList, int start_index=0);
  virtual bool fillNextInput(Jet::jet_list_t &inputList, int start_index = 0);
  virtual void moveToEventN(int n);

  virtual void init_collection(JetCollection &coll);

  void invert_input_order(bool in) {invert = in;}
	void usePartonLevel() {m_doStable = false; m_doParton = true;}

protected:

  bool invert;
	bool m_doParton;
	bool m_doStable;
};

}  // namespace SpartyJet
#endif
