#ifndef _JETINPUTMAKER_HH_
#define _JETINPUTMAKER_HH_

#include "JetCollection.hh"
#include "CommonUtils.hh"
#include "CustomMessage.hh"
#include <vector>
#include <string>
#include <fstream>

#include <TTree.h>
#include <TFile.h>
namespace SpartyJet { 


class InputMaker {
public:
  InputMaker() {m_name="Input"; m_reject_bad_input=false; m_GeV=1.; m_MeV=0.001;}
  virtual ~InputMaker(){};
  virtual void init() = 0;
  virtual void fillInput(int eventn, Jet::jet_list_t &inputList, int start_index = 0) = 0;
  virtual bool fillNextInput(Jet::jet_list_t &inputList, int start_index = 0) =0;
  
  virtual void moveToEventN(int n) = 0;
  int eventNumber() {return m_currentEvnt;};

  virtual void init_collection(JetCollection &coll){};

  // Units are fixed by input. Following function should be call
  // in the init() method
	// Default is GeV
  void setGeVUnits(double unit){m_GeV=unit; m_MeV=m_GeV/1000.;}
  void setMeVUnits(double unit){m_MeV=unit; m_GeV=m_MeV*1000.;}
  void unitIsGeV(){m_GeV=1.; m_MeV=m_GeV/1000.;}
  void unitIsMeV(){m_MeV=1.; m_GeV=m_MeV*1000.;}

  double getGeV(){return m_GeV;}
  double getMeV(){return m_MeV;}

  std::string name(){return m_name;}
  void set_name(std::string name){m_name =name;}
  virtual void reject_bad_input(bool v){m_reject_bad_input = v;}


  static bool check_4vector(Jet* jet) { return check_neg_energy(jet) && check_pz_energy(jet) ;}
  static bool check_neg_energy(Jet* jet){ return jet->e()>0;}
  static bool check_pz_energy(Jet* jet) {return fabs(jet->pz()) < jet->e();}

  int current_event(){return m_currentEvnt;}

protected:
  
  std::string m_name;
  
	double m_GeV;
  double m_MeV;
  
  int m_currentEvnt;

  bool m_reject_bad_input; // if true
  
	Message m_log;

};





class TextInputMaker : public InputMaker {
public:
  
  TextInputMaker() : InputMaker() {};

  virtual ~TextInputMaker() {delete file;}
  virtual void init() {};
  virtual void init(std::string filename) {};
  virtual void fillInput(int eventn, Jet::jet_list_t &inputList, int start_index = 0) {};
  virtual bool fillNextInput(Jet::jet_list_t &inputList, int start_index=0) =0;

  virtual void moveToEventN(int n) = 0;

protected:
  ifstream* file;
  std::string m_filename;
};


class HepInputMaker : public InputMaker {
public:
  
  HepInputMaker() : InputMaker() {}

  virtual ~HepInputMaker() {}
  virtual void init() {};
  virtual void init(std::string filename) {};
  virtual void fillInput(int eventn, Jet::jet_list_t &inputList, int start_index = 0) {};
  virtual bool fillNextInput(Jet::jet_list_t &inputList, int start_index = 0) =0;

  virtual void moveToEventN(int n) = 0;

protected:
  std::string m_filename;
};

}  // namespace SpartyJet
#endif
