#ifndef _JETINPUTMAKERNTUPLE_HH_
#define _JETINPUTMAKERNTUPLE_HH_



#include "CommonUtils.hh"
#include "InputMaker.hh"
#include "TreeBranchUtils.hh"
#include <string>


#include <TTree.h>
#include <TFile.h>

//class TBranch;

namespace SpartyJet { 
  

class NtupleInputMaker;
// *************************************************************
// NtupleInputBase
// A base class to read 4 vectors into SpartyJet.
// 
// It's an interface, don't use it. Use a derived class.
// *************************************************************
class NtupleInputBase : public InputMaker {
public:
  //  friend class NtupleInputMaker;

  NtupleInputBase();
  virtual void init() {};
  virtual void setFileTree(std::string filename, std::string treename) ;
  virtual void fillInput(int eventn, Jet::jet_list_t &inputList, int start_index = 0) {};
  virtual bool fillNextInput(Jet::jet_list_t &inputList, int start_index = 0);

  virtual void moveToEventN(int n) {m_currentEvnt = n;};

  virtual void set_prefix(std::string s){ m_prefix = s;}
  virtual void set_suffix(std::string s){ m_suffix = s;}
  virtual void set_variables(std::string p1,std::string p2,std::string p3,std::string p0){};
  virtual void set_n_name(std::string s){m_s_n=s;};
  void read_pdgId(bool b) { m_readPdgId=b; }
  void set_pdgId_name(std::string s) { m_pdgId_name=s;m_readPdgId=true; }

  //virtual int eventNumber() {return m_totalEvntN;};
  //void set_name(std::string name){m_log.set_name(name);}
  
  // This is experimental. Don't ship it by default.
  //virtual void doFastRead(int max_mem = 1000000){m_maxmem = max_mem;m_fastReading=true;};

  virtual TTree* get_tree(){return m_tree;}
  virtual TFile* get_file(){return m_f;}

protected:
  std::string m_prefix;
  std::string m_suffix;
  int m_totalEvntN;

  int m_n;
  TBranch * m_b_n;
  std::string m_s_n;
  bool m_readPdgId;
  std::string m_pdgId_name;

  TTree * m_tree;  
  TFile *m_f;


  //bool m_fastReading;
  int m_maxmem;
};



// *************************************************************
// NtupleInputMaker
// A generic class to read 4 vectors into SpartyJet.
// 
// This class is intended to be a wrapper for internal
// templated class. The reason is that rootcint doesn't handle
// correctly templates. This also allows to give a unique interface to
// the user.
// *************************************************************
  class IFourVecCollection;

class NtupleInputMaker : public NtupleInputBase {
public:

  // enumerate different ways input can be stored in a ROOT file
  enum NtupleInputType { 
    PxPyPzE_vector_double = 0,  
    PxPyPzE_vector_float,
    PxPyPzE_array_double,
    PxPyPzE_array_float,
    EtaPhiPtE_vector_double,  
    EtaPhiPtE_vector_float,
    EtaPhiPtE_array_double,
    EtaPhiPtE_array_float,
    EtaPhiPtM_vector_double,
    EtaPhiPtM_vector_float,
    EtaPhiPtM_array_double,
    EtaPhiPtM_array_float,
  } ;

  //NtupleInputMaker(NtupleInputType t = PxPyPzE_vector_double);
  NtupleInputMaker( int input_type = PxPyPzE_vector_double); // we use a int because of enum bug in ROOT 5.18
  ~NtupleInputMaker();

  // Wrap all base functions
  virtual void Constructor(NtupleInputType t); // generic constructor called by other constructors
  virtual void init() ;
  virtual void fillInput(int eventn, Jet::jet_list_t &inputList, int start_index=0);
  
  virtual void set_prefix(std::string s);
  virtual void set_suffix(std::string s);
  virtual void set_variables(std::string p1,std::string p2,std::string p3,std::string p0);
  virtual void set_n_name(std::string s);
  virtual void init_collection(JetCollection &coll);

  /// If input is in the form EtaPhiPtE one can set massless mode to true. In this case only Eta,Phi and E variables will be used
  void set_masslessMode(bool m);
  
  void reject_bad_input(bool v);


protected:
  IFourVecCollection *m_actualInput;
  BranchWrap_vector<int> *m_pdgIdVec; 
  BranchWrap_array<int,15000>  *m_pdgIdArr; 

};


}  // namespace SpartyJet
#endif
