#include "Jet.hh"
#include <iostream>

namespace SpartyJet { 

  //std::set<Jet *> Jet::deadJets;

Jet::Jet(Jet &jet) : LorentzVector(0,0,0,0){
  add(jet);
  m_index = jet.index();
  m_constituents = jet.m_constituents;
  //  m_area = jet.area();
  //  m_area_error = jet.area_error();
}
Jet::Jet(Jet* j){
  add(*j);
  m_index = j->index();
  m_constituents = j->m_constituents;
//   m_area = j->area();
//   m_area_error = j->area_error();
}

  Jet::~Jet(){
    //std::cout << " Jet dying "<< this << std::endl; deadJets.insert(this);
  }

void Jet::addJet(Jet& j){
  add(j);
  m_constituents.insert(m_constituents.end(), j.firstConstituent(), j.lastConstituent() );
}

void Jet::addJet(Jet* j){
  add(*j) ;
  m_constituents.insert(m_constituents.end(), j->firstConstituent(), j->lastConstituent() );
}


void Jet::addConstituent(constit_vect_t::iterator first, constit_vect_t::iterator last){
  m_constituents.insert(m_constituents.end(), first, last); 
  for(; first!=last;++first) this->add( **first);
}



Jet* jet_from_overlap(Jet* j1, Jet* j2){
  Jet *j = new Jet();
  Jet::constit_vect_t::iterator it1 = j1->firstConstituent();
  Jet::constit_vect_t::iterator it1E = j1->lastConstituent();
  for(;it1!= it1E; ++it1){
    Jet::constit_vect_t::iterator it2 = j2->firstConstituent();
    Jet::constit_vect_t::iterator it2E = j2->lastConstituent();
    for(;it2!= it2E; ++it2){
      if( *it1 == *it2) j->addConstituent(*it1);
    }
    
  }
  return j;
}

  
}  // namespace SpartyJet
