#include "JetCollection.hh"
#include <iostream>
#include <set>

namespace SpartyJet { 
  typedef std::set<Jet*> jet_set_t;
  
  void JetCollection::copy(const JetCollection & jcoll, bool copy_hist, bool copy_moment) {
    if(copy_hist) {m_history = jcoll.m_history ; }
    if(copy_moment) m_map = jcoll.m_map;
  }

	void JetCollection::deep_copy(const JetCollection & jcoll) {
		const JetMomentMap *tmpMap = &(jcoll.m_map);
		
		// Get orignial number of moments in output collection
		int nMomAlg = m_map.num_jet_moment();
		int nMomArrayAlg = m_map.num_jet_moment_array();
		
		// Schedule moments from input Coll
		for(int m=0;m<tmpMap->num_jet_moment();++m)
			m_map.schedule_jet_moment(tmpMap->moment_name(m));
		for(int m=0;m<tmpMap->num_jet_moment_array();++m)
			m_map.schedule_jet_moment_array(tmpMap->moment_array_name(m));
		
		// Do the copy
		Jet::jet_list_t::const_iterator jit  = jcoll.begin();
		Jet::jet_list_t::const_iterator jitE = jcoll.end();
		for(; jit != jitE; ++jit)
		{
			Jet * j = new Jet();
			j->set_index((*jit)->index());
			j->addConstituent(*jit); // make input jet constituent of new jet
			this->push_back(j);
			// Copy the map correctly (associating values to new Jets)
			for(int m=0;m<tmpMap->num_jet_moment();++m)
			{
				m_map.set_jet_moment(nMomAlg+m,j,tmpMap->get_jet_moment(m,*jit));
				//std::cout << "Setting value: " << tmpMap->get_jet_moment(m,*jit) <<  
				//	" for moment: " << tmpMap->moment_name(m) <<
				//	" to position: " << nMomAlg+m << std::endl;
			}
			for(int m=0;m<tmpMap->num_jet_moment_array();++m)
			{
				std::vector<float> tmpArr = tmpMap->get_jet_moment_array(m,*jit);
				m_map.set_jet_moment_array(nMomArrayAlg+m,j,tmpArr);
				//m_map.set_jet_moment_array(nMomArrayAlg+m,j,tmpMap->get_jet_moment_array(m,*jit));
			}
		}

		// Copy event moments
		// Get orignial number of moments in output collection
		int nEvtMomAlg 		= m_map.num_event_moment();
		int nEvtMomArrayAlg= m_map.num_event_moment_array();
		
		// Schedule moments from input Coll
		for(int m=0;m<tmpMap->num_event_moment();++m)
		{
			m_map.schedule_event_moment(tmpMap->event_moment_name(m));
			float tmpVal = tmpMap->get_event_moment()->at(m);
			m_map.set_event_moment(nEvtMomAlg+m,tmpVal);
		}
		for(int m=0;m<tmpMap->num_event_moment_array();++m)
		{
			m_map.schedule_event_moment_array(tmpMap->event_moment_array_name(m));
			std::vector<float> tmpArr = tmpMap->get_event_moment_array()->at(m);
			m_map.set_event_moment_array(nEvtMomArrayAlg+m,tmpArr);
		}
		
	}

	void JetCollection::deep_copy(const Jet::jet_list_t & jcoll) {
		Jet::jet_list_t::const_iterator jit  = jcoll.begin();
		Jet::jet_list_t::const_iterator jitE = jcoll.end();
		for(; jit != jitE; ++jit)
		{
			Jet * j = new Jet();
			j->set_index((*jit)->index());
			j->addConstituent(*jit); // make input jet constituent of new jet
			this->push_back(j);
		}
	}

  void JetCollection::swap(JetCollection &jcoll){
    Jet::jet_list_t::swap(jcoll);
    m_history.swap(jcoll.m_history);
    //    m_history_index.swap(jcoll.m_history_index);
    m_map.swap(jcoll.m_map);
  }


  void JetCollection::clear(){
    Jet::jet_list_t::clear();
    //    m_history_index.clear();
    m_history.clear();
    m_map.clear();
  }

  void JetCollection::clear_and_delete(){
    clear_list(* ((Jet::jet_list_t*)this) ); 
    m_map.clear();
    //    m_history_index.clear();
    m_history.clear();
  }


  void JetCollection::filter_in(Jet::jet_list_t &toKeep){
    //filter(toKeep, true);
    Jet::jet_list_t::swap(toKeep);
  }
  void JetCollection::filter_out(Jet::jet_list_t &toremove){

    jet_set_t remove(toremove.begin(), toremove.end() );
    jet_set_t::iterator end = remove.end();

    // use this vector to store kept jets in sync
    Jet::jet_list_t     kept_ordered;

    size_t N = size();

    kept_ordered.reserve(N);
    int k = 0;
    for(size_t i=0;i<N;i++){
      Jet* j = this->operator[](i);
      bool in = remove.find(j) == end;
      if(in) {
        kept_ordered.push_back(j);
        j->set_index(k); k++;
      }
    }
    Jet::jet_list_t::swap(kept_ordered);      
  }
  

/// Shortcut functions to jetMoment
float JetCollection::get_jet_moment(std::string mom_name,  Jet* jet){
  return m_map.get_jet_moment(mom_name,jet);
}
float JetCollection::get_jet_moment(std::string mom_name,  int jet_index){
  Jet *j = this->operator[](jet_index);
  return m_map.get_jet_moment(mom_name,j);
}

/// Shortcut functions to jetMoment
std::vector<float> JetCollection::get_jet_moment_array(std::string mom_name,  Jet* jet){
  return m_map.get_jet_moment_array(mom_name,jet);
}
std::vector<float> JetCollection::get_jet_moment_array(std::string mom_name,  int jet_index){
  Jet *j = this->operator[](jet_index);
  return m_map.get_jet_moment_array(mom_name,j);
}


JetCollection & JetCollection::operator=(const JetCollection &coll){
  // Call operator= for parent class.
  Jet::jet_list_t::operator=((Jet::jet_list_t) coll);
  return *this;}



  void JetCollection::prepare_history(int n){
    m_history.resize(n);
    //size_t Nh = m_history.size();
    // for(size_t i=0;i<Nh;i++){
    //   m_history[i].init();
    // }    
  }

  void JetCollection::history_dump(){
    size_t Nh = m_history.size();
    for(size_t i=0;i<Nh;i++){
      HistoryElement &el = m_history[i];
      if(! el.parent1() ){
        //if( Jet::deadJets.find( el.jet ) != Jet::deadJets.end() ) std::cout << i<< " -> dead jets "<< el.jet << std::endl;
        //std::cout << i<< "  ---> constituent   jet = " << el.jet << " el="<< &el<< std::endl;
        if(! el.jet()) std::cout << i <<  "     No parent, no jet !  hindex="<< el.hindex() << std::endl;
        //else std::cout << std::endl;
      }
    }
  }

}  // namespace SpartyJet

