#ifndef _JETCOLLECTION_HH_
#define _JETCOLLECTION_HH_

#include "Jet.hh"
#include "JetMomentMap.hh"
#include "JetHistory.hh"
#include "CommonUtils.hh"

//////////////////////////////////////////////////////////////////
/// a JetCollection is simply a list of jet with a JetMomentMap.
/// JetMoment are associated to jets through a map (in JetMomentMap) which allows
/// fast retrieval/setting of moments for a given jet
namespace SpartyJet { 
////////////////////////////////////////////////////////////////// 
class JetCollection : public Jet::jet_list_t {
public:

  JetCollection() : Jet::jet_list_t(){};
  JetCollection(const Jet::jet_list_t & jetlist) : Jet::jet_list_t(jetlist){};
  JetCollection(const JetCollection & jetlist) : Jet::jet_list_t(jetlist){ copy(jetlist);};
  ~JetCollection(){}


  /// Warning ! the copy policy is probably non optimal and non clean
  /// currently it is made to work in simple cases only, avoiding full history copying
  JetCollection  &operator=(JetCollection & jetcoll) { ((Jet::jet_list_t*) this)->operator=(jetcoll); copy(jetcoll); return *this; }

  
  void copy(const JetCollection & jcoll, bool copy_hist=true, bool copy_moment=true);
  void deep_copy(const JetCollection & jcoll);
  void deep_copy(const Jet::jet_list_t & jcoll);

  /// swap content of collections (moment map not affected yet)
  void swap(JetCollection &jcoll);

  
  /// filtering operation aware of history
  void filter_in(Jet::jet_list_t &toKeep);
  void filter_out(Jet::jet_list_t &toremove);

  /// empty collection (without destroying jets)
  void clear();

  /// This destroy the pointed Jets and clear the lists
  void clear_and_delete();


  /// Shortcut functions to jetMoment
  float get_jet_moment(std::string mom_name,  Jet* jet);
  float get_jet_moment(std::string mom_name,  int jet_index);

  /// Shortcut functions to jetMoment array
  std::vector<float> get_jet_moment_array(std::string mom_name,  Jet* jet);
  std::vector<float> get_jet_moment_array(std::string mom_name,  int jet_index);

  

  JetMomentMap * get_JetMomentMap() {return &m_map;}

  // The = operation copies only the list of jets, not the map
  JetCollection & operator=(const JetCollection &coll);
  typedef Jet::jet_list_t::const_iterator const_iterator;
  

  std::vector<HistoryElement> * history() {return &m_history;}
  size_t history_size() const {return m_history.size();}
  bool has_history(){return m_history.size()>0;}
  void prepare_history(int n);
  


  void history_dump();
  //Jet * operator[](size_t i){return this->operator[](i);}
  
protected:

  JetMomentMap m_map;
  std::vector<HistoryElement> m_history;
};


}  // namespace SpartyJet
#endif

