#include <iostream>
#include "JetMomentMap.hh"
namespace SpartyJet { 

void JetMomentMap::schedule_jet_moment(std::string name){
  m_momnames.push_back(name);  
}

void JetMomentMap::remove_jet_moment(std::string name){
	// Note: only removes it from list of names, not from value stores
	int pos = this->get_jet_momentPos(name);
	if(pos>-1)
		m_momnames.erase(m_momnames.begin()+pos);
}

int  JetMomentMap::get_jet_momentPos(std::string name) const {
  int i=0;
  int n=m_momnames.size();
  while(i<n){
    if(name == m_momnames[i]) return i;
    i++;
  }
  return -1;
}

float JetMomentMap::get_jet_moment(std::string mom_name,  Jet* jet) const {
  int i = get_jet_momentPos(mom_name);
  if(i==-1) {
    std::cout << "WARNING no such moment "<< mom_name << std::endl;
    return 0;
  }
	return get_jet_moment(i,jet);
}

float JetMomentMap::get_jet_moment(int i,  Jet* jet) const {
  value_store_t *val = get_jet_moments(jet);
  if(!val) {
    std::cout << "WARNING no such jet "<< jet << std::endl;
    return 0;
  }
  return val->operator[](i);
  
}

void JetMomentMap::schedule_jet_moment_array(std::string name){
  m_momarray_names.push_back(name);  
}

int  JetMomentMap::get_jet_moment_arrayPos(std::string name) const {
  int i=0;
  int n=m_momarray_names.size();
  while(i<n){
    if(name == m_momarray_names[i]) return i;
    i++;
  }
  return -1;
}

std::vector<float> JetMomentMap::get_jet_moment_array(std::string mom_name,  Jet* jet) const {
  int i = get_jet_moment_arrayPos(mom_name);
  if(i==-1) {
    std::cout << "WARNING no such moment array  "<< mom_name << std::endl;
    return std::vector<float>();
  }
  valuearray_store_t *val = get_jet_moment_arrays(jet);
  if(!val) {
    std::cout << "WARNING no such jet "<< jet << std::endl;
    return std::vector<float>();
  }
  return val->operator[](i);
}

std::vector<float> JetMomentMap::get_jet_moment_array(int i,  Jet* jet) const {
  valuearray_store_t *val = get_jet_moment_arrays(jet);
  if(!val) {
    std::cout << "WARNING no such jet "<< jet << std::endl;
    return std::vector<float>();
  }
  return val->operator[](i);
}


void JetMomentMap::schedule_event_moment(std::string name){
  m_globalnames.push_back(name);
}

int  JetMomentMap::get_event_momentPos(std::string name) const {
  int i=0;
  int n=m_globalnames.size();
  while(i<n){
    if(name == m_globalnames[i]) return i;
    i++;
  }
  return -1;
}

void JetMomentMap::schedule_event_moment_array(std::string name){
  m_globalarraynames.push_back(name);
}

int  JetMomentMap::get_event_moment_arrayPos(std::string name) const {
  int i=0;
  int n=m_globalarraynames.size();
  while(i<n){
    if(name == m_globalarraynames[i]) return i;
    i++;
  }
  return -1;
}

// Moment get - set ------------------------------------------
void JetMomentMap::i_set_jet_moment(int pos, Jet* jet, float value){
  moment_map_t::iterator it = m_map.find(jet);
  int size = (jet==NULL) ? m_globalnames.size() : m_momnames.size();
  value_store_t *store;
  if (it == m_map.end() ){
    store = new value_store_t(size);
    m_map[jet] = store;
  } else {
    store = (*it).second;
  }
  (*store)[pos] = value;
}

JetMomentMap::value_store_t* JetMomentMap::i_get_jet_moments(Jet* jet) const {
  moment_map_t::const_iterator it = m_map.find(jet);
  if (it == m_map.end() ){
    return NULL;
  } else {
    return (*it).second;
  }
}


// MomentArray get - set ------------------------------------------
void JetMomentMap::i_set_jet_moment_array(int pos, Jet* jet,value_store_t & theArray){
  momentarray_map_t::iterator it = m_array_map.find(jet);
  int size = (jet==NULL) ? m_globalarraynames.size() : m_momarray_names.size();
  //if(jet==NULL) return ; // global moment array not implemented yet
  valuearray_store_t *store;
  if (it == m_array_map.end() ){
    store = new valuearray_store_t(size);
    m_array_map[jet] = store;
  } else {
    store = (*it).second;
  }
  (*store)[pos] = theArray;
}

JetMomentMap::valuearray_store_t* JetMomentMap::i_get_jet_moment_arrays(Jet* jet) const {
  momentarray_map_t::const_iterator it = m_array_map.find(jet);
  if (it == m_array_map.end() ){
    return NULL;
  } else {
    return (*it).second;
  }
}


void JetMomentMap::clear(){
  moment_map_t::iterator it = m_map.begin();
  moment_map_t::iterator itE = m_map.end();
  for(;it !=itE; ++it) delete (*it).second;
  m_map.clear();

  momentarray_map_t::iterator ait =  m_array_map.begin();
  momentarray_map_t::iterator aitE = m_array_map.end();
  for(;ait !=aitE; ++ait) delete (*ait).second;
  m_array_map.clear();
}

// this function copies the layout of the JetMoments in the map
// and explicitly the EventMoments in the map.  this is commonly
// used just before jet finding which breaks the jet moments, but
// leaves event moments entact
void JetMomentMap::copy_structure(JetMomentMap &map){
	// Copy names of jet moments
  m_momnames = map.m_momnames;
  m_momarray_names = map.m_momarray_names;
	// Copy names of event moments
  m_globalnames = map.m_globalnames;
  m_globalarraynames = map.m_globalarraynames;
	
	// Copy values in event moments	
	moment_map_t::iterator itr = map.m_map.find(NULL);
	if(itr != map.m_map.end())
	{
		unsigned int nMom = (*itr).second->size();
  	value_store_t *store = new value_store_t(nMom);
    m_map[NULL] = store;
		for(unsigned int pos=0;pos<nMom;++pos)
			(*store)[pos] = (*itr).second->at(pos);
	}
	momentarray_map_t::iterator itrA = map.m_array_map.find(NULL);
	if(itrA != map.m_array_map.end())
	{
		unsigned int nMomA = (*itrA).second->size();
  	valuearray_store_t *store = new valuearray_store_t(nMomA);
    m_array_map[NULL] = store;
		for(unsigned int pos=0;pos<nMomA;++pos)
			(*store)[pos] = (*itrA).second->at(pos);
	}
}

  void JetMomentMap::swap(JetMomentMap &map){
    m_momnames.swap(map.m_momnames);
    m_momarray_names.swap(map.m_momarray_names);
    m_globalnames.swap(map.m_globalnames);
    m_globalarraynames.swap(map.m_globalarraynames);

    m_map.swap(map.m_map);
    m_array_map.swap(map.m_array_map);
  }
}  // namespace SpartyJet
