#include "JetNegEnergyTool.hh"

namespace SpartyJet { 

void JetNegEnergyTool::execute(JetCollection &inputJets){

  //m_log << "Execute  !" << m_acquiring<< std::endl;
  if(m_acquiring) acquisition(inputJets);
  else correction(inputJets);

}


void JetNegEnergyTool::acquisition(JetCollection &inputJets){

  JetCollection::iterator it = inputJets.begin();
  JetCollection::iterator itE = inputJets.end();
  for(; it !=itE; ++it){
    Jet::constit_vect_t::iterator constit_it = (*it)->firstConstituent();
    if( constit_it == (*it)->lastConstituent() ){
      // Ill formed jet !!! Before jet finding one expects 1 constituent per jet!
      m_log << "WARNING !!! jet has no constituent !" << std::endl;
      continue;
    }
    Jet *constit = *constit_it;
    //m_log << "Acquisition  "<< constit->e() << std::endl;
    if(constit->e() < 0){
      m_log << " Found "<< constit->e() << std::endl;
      constit->setE(-constit->e());
      m_neg_constits.insert(constit);
    }
  }
  
  m_acquiring = false;
}

void JetNegEnergyTool::correction(JetCollection &inputJets){

  JetCollection::iterator it = inputJets.begin();
  JetCollection::iterator itE = inputJets.end();

  jet_list_t::iterator end_neg = m_neg_constits.end();

  for(; it !=itE; ++it){
    Jet::constit_vect_t::iterator constit_it = (*it)->firstConstituent();
    Jet::constit_vect_t::iterator constit_itE = (*it)->lastConstituent();
    for(; constit_it != constit_itE; ++constit_it){
      jet_list_t::iterator pos = m_neg_constits.find(*constit_it);
      if( pos != end_neg){
	// We have to correct the jet
	Jet *jet = *it;
	Jet *constit = *constit_it;
	constit->setE(-constit->e());
	m_log << " correcting "<< constit->e() << std::endl;
	jet->setE(jet->e() - 2* constit->e());
	m_neg_constits.erase(pos);
      }
    }
  }  
  
  m_acquiring = true;
}
}  // namespace SpartyJet
