#ifndef _JETNEGENERGYTOOL_HH_
#define _JETNEGENERGYTOOL_HH_
/// ******************************************************
/// JetNegEnergyTool. A JetTool to manage jet constituent with e<0

// ToDo next :
// Use moment to store amounts of negative energy detected


#include "JetTool.hh"
#include <set>
namespace SpartyJet { 

class JetNegEnergyTool : public JetTool {
public :
  JetNegEnergyTool(std::string name) : JetTool(name), m_acquiring(true){};

  /// execute() call either acquisition() or correction() depending on m_acquiring switch
  virtual void execute(JetCollection &inputJets);
  
protected:
  typedef std::set<Jet *> jet_list_t;

  /// acquisition is supposed to run before jet finding
  /// It keeps tracks of all jets constituent having negative energy, changing
  ///  the energy sign so jet finding can correctly handle this constituent
  void acquisition(JetCollection &inputJets);

  /// correction is supposed to run after jet finding
  /// It loop on constituents of each jets, checking if a constituent has been kept as negative.
  /// if so it substracts the amount of energy to the parent jet
  void correction(JetCollection &inputJets);

  jet_list_t m_neg_constits;
  bool m_acquiring;
};

}  // namespace SpartyJet
#endif
