#ifndef _JETTOOL_HH_
#define _JETTOOL_HH_

#include "Jet.hh"
#include <list>
#include <string>
#include "CustomMessage.hh"
#include "JetMomentMap.hh"
#include "JetCollection.hh"

// JetTool is the base class from which
// all operations on jet_list must be perform
// Concrete class such as jet finder algo must be implemented
// in a derived class.
namespace SpartyJet { 

class JetMomentMap;
class JetTool {

public :
  JetTool() : m_name(), m_updateHistory(false){};
  virtual ~JetTool(){};
  JetTool(std::string name) : m_name(name), m_updateHistory(false) { m_log.set_name(name);};
  virtual void init(JetMomentMap *mmap=0) { };
  virtual void execute(JetCollection &inputJets) {};
  virtual void finalize() {};

  //  virtual void set_mmap(JetMomentMap *mmap){m_mmap =mmap;}
  std::string name(){return m_name;}
  void set_name(std::string n){m_name = n;}


  virtual bool contains_area() {return false;}
  virtual double getConeRadius() {return 0.0;}

  bool updateHistory(){return m_updateHistory;}

protected:
  //JetMomentMap *m_mmap;
  std::string m_name;

  bool m_updateHistory;
  Message m_log;

};


}  // namespace SpartyJet
#endif
