#include "LheInput.hh"
#include <iostream>
#include <sstream>

// this is to avoid a gcc 3.2.3 problem
char* operator+( std::streampos&, char* );
namespace SpartyJet { 

	void LheInput::init(std::string filename) {
		if(file != NULL)
			delete file;
		file = new ifstream(filename.c_str());

		unitIsGeV(); // SpartyJet default

		m_currentEvnt = 0;
		m_filename = filename;
		invert = false;
		if(!file->is_open())
			m_log << ERROR << "LheInput file " << filename << " did not open correctly!" << std::endl;
	}

	void LheInput::init_collection(JetCollection &coll){
		coll.get_JetMomentMap()->schedule_jet_moment("pdgId");
	}

	void LheInput::fillInput(int eventn, Jet::jet_list_t &inputList, int start_index) {
		moveToEventN(eventn);
		fillNextInput(inputList, start_index);
	}

	bool LheInput::fillNextInput(Jet::jet_list_t &inputList, int start_index) {
		std::string line;
		double px,py,pz,E,mass;
		int pdgid,status,mother1,mother2,color1,color2;
		int num_inserted=0;

		// check if we can get a moment map:
		JetCollection *coll = static_cast<JetCollection*>(&inputList); 
		JetMomentMap *map = 0;
		int pdgid_map_pos = -1;
		if(coll){
			map = coll->get_JetMomentMap();
			pdgid_map_pos = map->get_jet_momentPos("pdgId");
		}

		// Read from file
		while(*file)
		{
			//  Look for <event> tag
			getline(*file,line);
			if( line.find("<event>") != std::string::npos) 
			{
				// First Line after <event> contains event information
				getline(*file,line);
						// Fill event info

				// Get particle info
				getline(*file,line); // 1st particle
				while(line.find("</event>") == std::string::npos)
				{
					std::istringstream iss(line);
					iss >> pdgid >> status >> mother1 >> mother2 >> color1 >> color2 >> px >> py >> pz >> E >> mass;


					bool isStable = (status==1 );

					bool isParton = (status==22 || status==23);


					if( ( (m_doParton && isParton) || (m_doStable && isStable) ) && px != -1 && py != -1 && pz != -1 && E != -1) 
					{
						Jet* j = new Jet(px,py,pz,E, num_inserted+start_index);
						if(!m_reject_bad_input || check_4vector(j) ) inputList.push_back(j);
						if(map) map->set_jet_moment(pdgid_map_pos, j , pdgid); // add moment
						num_inserted++;
					}
					// Skip any comment lines in the file
					do 
					{
						getline(*file,line);
					}
					while(line[0]=='#');
				}
			}

			if(num_inserted > 0) 
			{
				m_currentEvnt++;
				return true;
			}
		} // end while(*file)

		// Something wrong, shouldn't have reached here
		return false;	
	
	}

	void LheInput::moveToEventN(int n) {
		std::string line;
		if(n == m_currentEvnt) return;        // already happen to be at that event
		init(m_filename);                  // start from beginning of file
		if(m_currentEvnt == n) return;     // if n == 0, this is needed

		while(*file) 
		{
			getline(*file,line);
			if( line.find("<event>") != std::string::npos) 
			{
				m_currentEvnt++;
				if(m_currentEvnt == n) return;
			}
		}

		return;
	}

}  // namespace SpartyJet
