#ifndef _LHE_INPUT_HH_
#define _LHE_INPUT_HH_

#include "JetCore/InputMaker.hh"
namespace SpartyJet { 

class LheInput : public TextInputMaker {
public:

  LheInput() : TextInputMaker() {
    m_filename = "";
    m_currentEvnt = -1;
    invert = false;
    m_name = "Lheinput";
		m_log.set_name(m_name);
		m_doStable = true;
		m_doParton = false;
  }
  LheInput(std::string filename) : TextInputMaker() {
    file = NULL;
    m_filename = filename; 
    init(filename);
    m_currentEvnt = 0;
    invert = false;
    m_name = "Lheinput";
		m_log.set_name(m_name);
		m_doStable = true;
		m_doParton = false;
  }
  
	virtual ~LheInput() {};

  virtual void init(std::string filename);
  virtual void fillInput(int eventn, Jet::jet_list_t &inputList, int start_index=0);
  virtual bool fillNextInput(Jet::jet_list_t &inputList, int start_index = 0);
  virtual void moveToEventN(int n);

  virtual void init_collection(JetCollection &coll);

  void invert_input_order(bool in) {invert = in;}
	void usePartonLevel() {m_doStable = false; m_doParton = true;}

protected:

  bool invert;
	bool m_doParton;
	bool m_doStable;
};

}  // namespace SpartyJet
#endif
