#ifndef _LORENTZ_VECTOR_HH_
#define _LORENTZ_VECTOR_HH_


#include "TLorentzVector.h"

/////////////////////////////////////////////////////////////////////
///
/// A LorentzVector implementation
///  Inherits from CLHEP::HepLorentzVector and thus have ALL its
///  methods. 
///  Some alias methods are added for convenience.
/////////////////////////////////////////////////////////////////////

//class LorentzVector : public CLHEP::HepLorentzVector
namespace SpartyJet { 
class LorentzVector : public TLorentzVector
{
 public:

  /// constructors
  //LorentzVector(): CLHEP::HepLorentzVector() {}
  LorentzVector(): TLorentzVector() {}
  LorentzVector(double p1, double p2, double p3, double p0):TLorentzVector(p1,p2,p3,p0) {}
  //LorentzVector(const LorentzVector& p): CLHEP::HepLorentzVector(p) {}
  LorentzVector(const LorentzVector& p): TLorentzVector(p) {}

  /// Templated constructor. To ease interface with other 4vec
  /// classes. For example define a new constructor for your own
  /// MyClass with :
  /// template<> LorentzVector::LorentzVector(const MyClass &vect){...}  
  template<class V>
  LorentzVector(const V& vector){}
  

  /// Inherited from TLorentzVector one have
  ///  px(), py(), pz(), e() 
  ///  x(), y(), z(), t() (alias of the above)
  ///  SetPx(), SetPy(), etc...
  /// Spherical coordinates :
  ///  theta() cosTheta(), rho(), phi()
  /// Masses : m() or mag()
  ///          m2() or mag2()
  /// Rapidity :
  ///  rapidity(), pseudo-rapidity(), eta()
  /// Transverse quantities : 
  ///  et(), et2(), mt(), mt2()
  /// ... plus many other functions... see TLorentzVector.h
  double p()        const {return P();}
  double pt()       const {return Perp();}
  double pt2()       const {return Perp2();}

  double mass()     const {return M();}
  double px()       const {return Px();}
  double py()       const {return Py();}
  double pz()       const {return Pz();}
  double phi()      const {return Phi();}
  double eta()      const {return Eta();}
  double et()      const {return Et();}
  double e()      const {return E();}
  double rapidity() const {return Rapidity();}  
  double perp2()  const {return Perp2();}

  void setE(double e){SetE(e);}

  void add(LorentzVector &v)        { this->operator+=(v); }
  void add(const LorentzVector &v)  { this->operator+=(v); }
  void subtract(LorentzVector &v)   { this->operator-=(v); }
  bool isEqual(LorentzVector &v)    { return (*this) == v; }

	ClassDef(LorentzVector, 0);
};

}  // namespace SpartyJet
#endif
