#include "NtupleMaker.hh"
#include "CommonUtils.hh"

namespace SpartyJet { 

  bool IGenericJetVar::do_phiconversion = false;


  NtupleMaker::NtupleMaker(){
    m_firstvar =NULL;
    m_tree = NULL ;
    m_file = NULL; 
  m_log.set_name("NtupleMaker");
}
NtupleMaker::~NtupleMaker(){

  jetvar_map_t::iterator it =  m_jetvarMap.begin();
  jetvar_map_t::iterator itE = m_jetvarMap.end();
  for(; it!= itE; ++it){
    delete (*it).second;
  }
  if(m_tree) delete m_tree;
  if(m_file) delete m_file;

}



/// Add a given JetVar to the ntuple
void NtupleMaker::addJetVar(IGenericJetVar * jv){
  m_log << DEBUG << "Adding IGenericJetVar "<< jv->name() << "  "<< jv << std::endl;
  m_jetvarMap[jv->name()] = jv;  
}

/// Build a standard JetVar & add it to the ntuple
// void NtupleMaker::addJetVar(std::string jetname, JetMomentMap *mmap){
//   JetVar *jv =  new JetVar(jetname,mmap);
//   addJetVar(jv);
// }

  void NtupleMaker::addInputJetVar(IGenericJetVar * jv){
    m_firstvar = jv;
    addJetVar(jv);
  }

void NtupleMaker::init(std::string treename, std::string treefile, bool update){
  m_log << DEBUG << "Initializing tree" << m_tree << std::endl;
  if(update)m_file = new TFile(treefile.c_str(),"UPDATE");
  else m_file = new TFile(treefile.c_str(),"RECREATE");
  m_file->cd();
  m_tree = new TTree(treename.c_str(), "SpartyJet tree");
  schedule();
}

  void NtupleMaker::init_with_ttree(TTree *t){
    m_file = t->GetCurrentFile();
    m_tree = t;
    schedule();
  }

/// Schedule every variables added with the addJetVar methods
void NtupleMaker::schedule(){
  if(m_firstvar != NULL) {
    m_firstvar->set_var_names(m_varnames );
    m_firstvar->schedule(m_tree);
    m_log << DEBUG << "Setting varnames to first var  "<< m_varnames.eta <<std::endl;

  }
  jetvar_map_t::iterator it = m_jetvarMap.begin();
  jetvar_map_t::iterator itE = m_jetvarMap.end();  
  for(; it != itE; ++it){    
    IGenericJetVar * jv = (*it).second;

    jv->set_var_names(m_varnames );

    if(jv != m_firstvar)
      jv->schedule(m_tree);
  }
}

/// Associate a jet_list  to a given JetVar named jetname 
void NtupleMaker::set_data(std::string jetname, JetCollection &theJets){
  jetvar_map_t::iterator it = m_jetvarMap.find(jetname);
  if (it != m_jetvarMap.end() ){
    m_log << DEBUG << "Setting data for "<< jetname << "  IGenericJetVar = "<< (*it).second->name() << std::endl;
    (*it).second->set_data(theJets);    
  } else {
    //didn't find jetname    
  }
  
}

void NtupleMaker::finalize(){
  m_file->cd();
  m_tree->Write();
  // tree deletion apparently needs to be done before
  // closing file
  if(m_tree) delete m_tree;
  m_tree = NULL;
  m_file->Close();
}

void NtupleMaker::fillJets(){
  m_tree->Fill();
}

IGenericJetVar * NtupleMaker::getJetVar(std::string name){
  jetvar_map_t::iterator it = m_jetvarMap.find(name);
  if(it==m_jetvarMap.end()) return NULL;
  else return (*it).second;
}

void NtupleMaker::set_var_names(std::string eta,std::string phi,std::string pt,std::string e,std::string mass, std::string ind, std::string numc ){
  m_varnames.eta = eta;
  m_varnames.phi = phi;
  m_varnames.pt  = pt;
  m_varnames.e   = e;
  m_varnames.mass = mass;
  m_varnames.ind = ind;
  m_varnames.numC = numc;
}
void NtupleMaker::clear_vars(){
  jetvar_map_t::iterator it =  m_jetvarMap.begin();
  jetvar_map_t::iterator itE = m_jetvarMap.end();
  for(; it!= itE; ++it){
    //delete (*it).second;
  }

}


}
