#ifndef _JETNTUPLEMAKER_HH_
#define _JETNTUPLEMAKER_HH_

#include <string>
#include <map>
#include <TTree.h>
#include <vector>

#include "Jet.hh"
#include "JetCollection.hh"

#include "CustomMessage.hh"
#include "OutputVarUtils.hh"


#define NMAX 10000
#define NMOM_ARRAY_MAX 4



namespace SpartyJet { 



// *****************************************************
// NtupleMaker : manage TTree and a collection of JetVar
//   and associate jet collections to the JetVars       
// *****************************************************
class NtupleMaker {

public:

  typedef std::map<std::string , IGenericJetVar*> jetvar_map_t;
    
  NtupleMaker();
  ~NtupleMaker();

  // Adding a GenericJetVar to the ntuple
  void addJetVar(IGenericJetVar * jv);
  // This creates a default JetVar named jetname with an associated JetMomentMap
  //void addJetVar(std::string jetname, JetMomentMap *mmap=0); deprecated
  // create a JetVar for the proto-jet input collection
  //void addInputJetVar(std::string jetname);
  void addInputJetVar(IGenericJetVar* jv);

  void init(std::string treename, std::string filename,bool update=false);
  void init_with_ttree(TTree *t);
  void finalize();

  void set_data(std::string jetname, JetCollection &theJets);

  void fillJets();
  //void fillJets(std::string jetname);


  // Re-access the JetVar object by its name
  IGenericJetVar * getJetVar(std::string name);


  void set_var_names(std::string eta,std::string phi,std::string pt,std::string e,std::string mass, std::string ind, std::string numc );
    

  void clear_vars();


  TTree * get_tree(){return m_tree;}
  TFile * get_file(){return m_file;}
protected:

  void schedule();

  TTree *m_tree;
  TFile *m_file;

  jetvar_map_t m_jetvarMap;

  IGenericJetVar *m_firstvar;

  Message m_log;

  JetVar_Names m_varnames;
};

}  // namespace SpartyJet
#endif


