#define OUTPUTVARUTILS_CC
#include "OutputVarUtils.hh"


namespace SpartyJet { 

  JetVar_Names::JetVar_Names(){
    eta =  "eta"; 
    phi =  "phi"; 
    pt =  "pt"; 
    e  =   "e";   
    mass = "mass";
    ind  = "ind" ;
    numC = "numC";
  }




  template<int NMAX>
  IGenericJetVar * OutputVarFactory::_get_jet_var(std::string name, JetMomentMap * map, IGenericJetVar * inputvar, bool onlymoment ){


    // Give shortcut names to every possible output types :
    typedef JetVarIndex< BranchWrap_simple<float> , BranchWrap_array<float, NMAX>, BranchWrap_array2D<float, NMAX, 5>, BranchWrap_array<int, NMAX*100> >    array_float_index;
    typedef JetVarIndex< BranchWrap_simple<double> , BranchWrap_array<double, NMAX>, BranchWrap_array2D<double, NMAX, 5> , BranchWrap_array<int, NMAX*100> > array_double_index;
    typedef JetVarIndex< BranchWrap_simple<float> , BranchWrap_vector<float>, BranchWrap_vector2D<float> , BranchWrap_vector<int> >                vector_float_index;
    typedef JetVarIndex< BranchWrap_simple<double> , BranchWrap_vector<double>, BranchWrap_vector2D<double>, BranchWrap_vector<int> >             vector_double_index;

    typedef GenericJetVar< BranchWrap_simple<float> , BranchWrap_array<float, NMAX>, BranchWrap_array2D<float, NMAX, 5> >    array_float_gen;
    typedef GenericJetVar< BranchWrap_simple<double> , BranchWrap_array<double, NMAX>, BranchWrap_array2D<double, NMAX, 5> > array_double_gen;
    typedef GenericJetVar< BranchWrap_simple<float> , BranchWrap_vector<float>, BranchWrap_vector2D<float> >                vector_float_gen;
    typedef GenericJetVar< BranchWrap_simple<double> , BranchWrap_vector<double>, BranchWrap_vector2D<double> >             vector_double_gen;

    typedef JetVar< BranchWrap_simple<float> , BranchWrap_array<float, NMAX>, BranchWrap_array2D<float, NMAX, 5> >    array_float;
    typedef JetVar< BranchWrap_simple<double> , BranchWrap_array<double, NMAX>, BranchWrap_array2D<double, NMAX, 5> > array_double;
    typedef JetVar< BranchWrap_simple<float> , BranchWrap_vector<float>, BranchWrap_vector2D<float> >                vector_float;
    typedef JetVar< BranchWrap_simple<double> , BranchWrap_vector<double>, BranchWrap_vector2D<double> >             vector_double;


    if (array_type == "array") {
      
      if (base_type =="float") {
	if(onlymoment) return new array_float_gen(name,map);
	if(inputvar) {
	  return prepare_input( new array_float_index(name,map) , inputvar);
	}else	  
	  return new array_float(name,map);
      }
      else if (base_type =="double") {
	if(onlymoment) return new array_double_gen(name,map);
	if(inputvar) {
	  return prepare_input( new array_double_index(name,map) , inputvar);
	}else	  
	  return new array_double(name,map);
      }
      else {
	std::cout<<" ERROR unknown base type "<< base_type <<" for output variables"<<std::endl;
      }
    } // array variables
    else if (array_type == "vector") {

      if (base_type =="float") {
	if(onlymoment) return new vector_float_gen(name,map);
	if(inputvar) {
	  return prepare_input( new vector_float_index(name,map) , inputvar);
	}else	  
	  return new vector_float(name,map);
      }
      else if (base_type =="double") {
	if(onlymoment) return new vector_double_gen(name,map);
	if(inputvar) {
	  return prepare_input( new vector_double_index(name,map) , inputvar);
	}else	  
	  return new vector_double(name,map);
      }
      else {
	std::cout<<" ERROR unknown base type "<< base_type <<" for output variables"<<std::endl;
      }

    }// vector variables
    else {
      std::cout<<" ERROR unknown array type "<< array_type <<" for output variables"<<std::endl;
    }
    
    return 0;
  }

  IGenericJetVar * OutputVarFactory::get_jet_var(std::string name, JetMomentMap * map, IGenericJetVar * inputvar , bool onlymoment){
    return _get_jet_var<100>(name,map,inputvar, onlymoment);
  }
  IGenericJetVar * OutputVarFactory::get_inputjet_var(std::string name, JetMomentMap *map){
    return _get_jet_var<10000>(name,map, NULL, false);
  }
}
