#include "PythiaInput.hh"
#include "TParticle.h"
#include "TDatabasePDG.h"
#include "TClonesArray.h"
#include "TPythia8.h"
#include <iostream>

namespace SpartyJet { 

	void PythiaInput::init(std::string filename) {
		unitIsGeV(); // SpartyJet default
		m_currentEvnt = 0;
		// Array of particles
		m_particles = new TClonesArray("TParticle", 10000);

	}

	void PythiaInput::init_collection(JetCollection &coll){
		coll.get_JetMomentMap()->schedule_jet_moment("pdgId");
	}

	void PythiaInput::fillInput(int eventn, Jet::jet_list_t &inputList, int start_index) {
		moveToEventN(eventn);
		fillNextInput(inputList, start_index);
	}

	bool PythiaInput::fillNextInput(Jet::jet_list_t &inputList, int start_index) {
		double px,py,pz,E,mass;
		int status,pdgid;
		int num_inserted=0;

		// check if we can get a moment map:
		JetCollection *coll = static_cast<JetCollection*>(&inputList); 
		JetMomentMap *map = 0;
		int pdgid_map_pos = -1;
		if(coll){
			map = coll->get_JetMomentMap();
			pdgid_map_pos = map->get_jet_momentPos("pdgId");
		}
		//-------------
		m_pythia->GenerateEvent();
		if(m_printEvent)
			((TPythia8*)m_pythia)->EventListing();
		m_pythia->ImportParticles(m_particles,"All");
		Int_t np = m_particles->GetEntriesFast();
		// Particle loop
		for (Int_t ip = 0; ip < np; ip++) {
			TParticle* part = (TParticle*) m_particles->At(ip);
			status = part->GetStatusCode();
			pdgid = part->GetPdgCode();
			//Float_t charge = TDatabasePDG::Instance()->GetParticle(pdg)->Charge();
			px  = part->Px();
			py  = part->Py();
			pz  = part->Pz();
			E   = part->Energy();
			if(!(TDatabasePDG::Instance()->GetParticle(pdgid)))
				mass = 0.134*m_GeV;
			else
				mass = part->GetMass();

			bool isStable = (status==1);
			bool isParton = (status>30 && status<44); // PYTHIA?


			if( ( (m_doParton && isParton) || (m_doStable && isStable) ) && px != -1 && py != -1 && pz != -1 && E != -1) 
			{
				Jet* j = new Jet(px,py,pz,E, num_inserted+start_index);
				if(!m_reject_bad_input || check_4vector(j) ) 
				{
					inputList.push_back(j);
					num_inserted++;
					if(map) map->set_jet_moment(pdgid_map_pos, j , pdgid); // add moment
				}
			}
		}
		m_currentEvnt++;
		return true;
	}

		void PythiaInput::moveToEventN(int n) {
			if(n == m_currentEvnt) return;        // already happen to be at that event
			init("");                  // start from beginning of file
			if(m_currentEvnt == n) return;     // if n == 0, this is needed

			while(m_currentEvnt != n) {
				m_pythia->GenerateEvent();
				m_currentEvnt++;
			} 

			return;
		}

	}  // namespace SpartyJet
