#ifndef _PYTHIA_INPUT_HH_
#define _PYTHIA_INPUT_HH_

// Class to run pythia generation and
// feed output to SpartyJet 


#include "JetCore/InputMaker.hh"
#include "TGenerator.h"

namespace SpartyJet { 

class PythiaInput : public HepInputMaker {
public:

  PythiaInput() : HepInputMaker() {
    m_currentEvnt = -1;
    m_name = "PythiaInput";
		m_log.set_name(m_name);
		m_doStable = true;
		m_doParton = false;
		m_printEvent = false;
  }
  PythiaInput(TGenerator* pythia) : HepInputMaker() {
    m_pythia = pythia;
		m_currentEvnt = 0;
    m_name = "PythiaInput";
		m_log.set_name(m_name);
		m_doStable = true;
		m_doParton = false;
		m_printEvent = false;
    init("");
  }
  
	virtual ~PythiaInput() {};

  virtual void init(std::string filename="");
  virtual void fillInput(int eventn, Jet::jet_list_t &inputList, int start_index=0);
  virtual bool fillNextInput(Jet::jet_list_t &inputList, int start_index = 0);
  virtual void moveToEventN(int n);

  virtual void init_collection(JetCollection &coll);
  virtual void reject_bad_input(bool v){m_reject_bad_input = v;}

	void setPythia(TGenerator* pythia) { m_pythia=pythia; }
	void printEvent(bool print=true) { m_printEvent = print; }
	void usePartonLevel() {m_doStable = false; m_doParton = true;}

protected:

	TGenerator* m_pythia;
	TClonesArray* m_particles;
	bool m_doParton;
	bool m_doStable;
	bool m_printEvent;
};

}  // namespace SpartyJet
#endif
