#include "StdHepInput.hh"
#include "CustomMessage.hh"
#include <iostream>

// this is to avoid a gcc 3.2.3 problem
char* operator+( std::streampos&, char* );
namespace SpartyJet { 

void StdHepInput::init(std::string filename) {
  unitIsGeV(); // SpartyJet default
  istr=0;
  nevt = 10000000;  // StdHep requires one to guess number of events
  // this number hardly matters
  ierr = StdHepXdrReadInit(const_cast<char*>(filename.c_str()),nevt,istr);
  m_currentEvnt = 0;
  m_filename = filename;
  if(ierr != 0)
	  m_log << ERROR << "StdHepInput file " << filename << " did not open correctly!" << std::endl;
}
  
void StdHepInput::init_collection(JetCollection &coll){
    coll.get_JetMomentMap()->schedule_jet_moment("pdgId");
}


void StdHepInput::fillInput(int eventn, Jet::jet_list_t &inputList) {
  moveToEventN(eventn);
  fillNextInput(inputList);
}

bool StdHepInput::fillNextInput(Jet::jet_list_t &inputList, int start_index) {
  
  double px,py,pz,E;
  int pdgId;

  inputList.clear();

  int num_inserted=start_index;
  
  // check if we can get a moment map:
  JetCollection *coll = static_cast<JetCollection*>(&inputList); 
  JetMomentMap *map = 0;
  int pdgid_map_pos = -1;
  if(coll){
    map = coll->get_JetMomentMap();
    pdgid_map_pos = map->get_jet_momentPos("pdgId");
  }

	// read next event
	ierr = StdHepXdrRead(&lbl,istr);
	if(ierr != 0) m_log << ERROR << "StdHepXdrRead returned error" << std::endl;
	m_currentEvnt++;
	if(ierr == 0) {
		do{ 
			for(int i = 0; i < hepevt_.nhep; i++) {   // loop through particles
				if(hepevt_.isthep[i] != 1) continue;     // only want final state particles

				px = hepevt_.phep[i][0];          // [i][4] = mass if needed
				py = hepevt_.phep[i][1];
				pz = hepevt_.phep[i][2];
				E  = hepevt_.phep[i][3];
				pdgId = hepevt_.idhep[i];

				Jet* j = new Jet(px,py,pz,E, num_inserted);
				if(!m_reject_bad_input || check_4vector(j) ) inputList.push_back(j);
				num_inserted++;
				if(map) map->set_jet_moment(pdgid_map_pos, j , pdgId); // add moment
			}

			if(m_skip_empty_events && inputList.size() == 0) {
				m_log << WARNING << "Skipping empty event." << std::endl;
				ierr = StdHepXdrRead(&lbl,istr);
				m_currentEvnt++;	
			}
			else 
			{
				break;           // leave while loop and return true
			}

		}while(ierr == 0);   // if problem, quit loop and return false
	}
  
  if(ierr == 0 && hepevt_.nevhep != -2)
    return true;         // no problems
  else
    return false;        // problem found (or nevhep == -2, last event)
}

void StdHepInput::set_skip_empty_events(bool s) {
  m_skip_empty_events = s;
}


void StdHepInput::moveToEventN(int n) {
  if(n == m_currentEvnt) return;        // already happen to be at that event

  if(n < m_currentEvnt)
    init(m_filename);                  // start from beginning of file

  do {
    ierr = StdHepXdrRead(&lbl,istr);
    if(ierr != 0) 
		{
			m_log << ERROR << "StdHepXdrRead returned error" << std::endl;
			return;                      // something went wrong, or end of file
		}
		m_currentEvnt++;	
  }while(n != m_currentEvnt);


  return;
}

}  // namespace SpartyJet
