#ifndef _STDHEP_INPUT_HH_
#define _STDHEP_INPUT_HH_

//C++
#include <stdio.h>
#include <stdlib.h>

//StdHep
#include "STDHEP/src/inc/stdhep.h"
#include "STDHEP/src/inc/stdlun.h"
#include "STDHEP/src/inc/stdcnt.h"
#include "STDHEP/src/inc/stdhep_mcfio.h"
//SpartyJet
#include "JetCore/InputMaker.hh"
namespace SpartyJet { 

class StdHepInput : public HepInputMaker {
public:

  StdHepInput() : HepInputMaker() {
    m_name = "StdHepInput";
    m_skip_empty_events = true;
		m_log.set_name(name());
  }
  StdHepInput(std::string filename) : HepInputMaker() {
    m_name = "StdHepInput";
    m_skip_empty_events = true;
		m_log.set_name(name());
    init(filename);
  }

  ~StdHepInput() {}
	virtual void init(std::string filename);
  virtual void fillInput(int eventn, Jet::jet_list_t &inputList);
  virtual bool fillNextInput(Jet::jet_list_t &inputList, int start_index=0);
  virtual void moveToEventN(int n);
  void set_skip_empty_events(bool);

  virtual void init_collection(JetCollection &coll);

protected:
  int ierr;
  int lbl;
  int istr;
  int nevt;
  bool m_skip_empty_events;
  std::string m_filename;
};

}  // namespace SpartyJet
#endif
