#include "StdTextInput.hh"
#include <iostream>

// this is to avoid a gcc 3.2.3 problem
char* operator+( std::streampos&, char* );
namespace SpartyJet { 

void StdTextInput::init(std::string filename) {
  if(file != NULL)
    delete file;
  file = new ifstream(filename.c_str());

  unitIsGeV(); // SpartyJet default

  m_currentEvnt = 0;
  m_filename = filename;
  invert = false;
  if(!file->is_open())
    std::cout << "StdTextInput :  file " << filename << " did not open correctly!\n";
}

void StdTextInput::fillInput(int eventn, Jet::jet_list_t &inputList) {
  moveToEventN(eventn);
  fillNextInput(inputList);
}

  bool StdTextInput::fillNextInput(Jet::jet_list_t &inputList, int start_index) {
  char peek;
  double px,py,pz,E;
  bool end = false;

  inputList.clear();

  int num_inserted=start_index;

  do {
    peek = file->peek();
    if(peek == 'n' || peek == 'N') {                           // n or N (new event)
      file->ignore(1000,'\n');
      if(inputList.size() > 0)
	end = true;
    } 
    else if(peek == 'e' || peek == 'E') {                    // e or E (end of file)
      end = true;
    } 
    else if(peek == 46) {                                    // dot
      file->get();
      peek = file->peek();
      file->ignore(1000,'\n');
      if(peek == 'e' || peek == 'E') {                       // .e or .E also ends the event
	if(inputList.size() > 0)
	  end = true;
      }
    }
    else if(peek == 47 || peek ==35)                         // slash or #
      file->ignore(1000,'\n');
    else {                                                   // data
      px = py = pz = E = -1;
      if(invert)
	*file >> px >> py >> pz >> E;
      else
	*file >> E >> px >> py >> pz;
      file->ignore(1000,'\n');
      if(px != -1 && py != -1 && pz != -1 && E != -1) {
	Jet* j = new Jet(px,py,pz,E, num_inserted);
	if(!m_reject_bad_input || InputMaker::check_4vector(j) ) {
	  inputList.push_back(j);
	  num_inserted++;
	}
      }
    }
  } while(*file && !end);
  if(inputList.size() > 0) {                              // event found with some jets
    m_currentEvnt++;
    return true;
  }
  else return false;                                         // no event found
}

void StdTextInput::moveToEventN(int n) {
  if(n == m_currentEvnt) return;        // already happen to be at that event
  
  init(m_filename);                  // start from beginning of file

  char peek;
  m_currentEvnt = 0;
  int jets = 0;
  double px,py,pz,E;               // dummy variables
  bool end = false;

  if(m_currentEvnt == n) return;

  do {
    peek = file->peek();
    if(peek == 'n' || peek == 'N') {                           // n or N (new event)
      file->ignore(1000,'\n');
      if(jets > 0) {
	m_currentEvnt++;
	jets = 0;
	if(m_currentEvnt == n) return;
      }
    } 
    else if(peek == 'e' || peek == 'E') {                    // e or E (end of file)
      end = true;
      if(jets > 0) {
	m_currentEvnt++;
	jets = 0;
	if(m_currentEvnt == n) return;
      }
    } 
    else if(peek == 46) {                                    // dot
      file->get();
      peek = file->peek();
      file->ignore(1000,'\n');
      if(peek == 'e' || peek == 'E') {                       // .e or .E also new event
	if(jets > 0) {
	  m_currentEvnt++;
	  jets = 0;
	  if(m_currentEvnt == n) return;
	}
      }
    }
    else if(peek == 47 || peek ==35)                       // dot, slash or #
      file->ignore(1000,'\n');
    else {                                                   // data
      *file >> px >> py >> pz >> E;
      jets++;
      file->ignore(1000,'\n');
    }
  } while(*file && !end);
  return;
}

}  // namespace SpartyJet
