#ifndef _STDFILE_INPUT_HH_
#define _STDFILE_INPUT_HH_

#include "JetCore/InputMaker.hh"
namespace SpartyJet { 

class StdTextInput : public TextInputMaker {
public:

  StdTextInput() : TextInputMaker() {
    m_filename = "";
    m_currentEvnt = -1;
    invert = false;
    m_name = "StdTextInput";
  }
  StdTextInput(std::string filename) : TextInputMaker() {
    file = NULL;
    m_filename = filename; 
    init(filename);
    m_currentEvnt = 0;
    invert = false;
    m_name = "StdTextInput";
  }

  virtual ~StdTextInput() {};

  //  StdTextInput(std::string filename);
  virtual void init(std::string filename);
  virtual void fillInput(int eventn, Jet::jet_list_t &inputList);
  virtual bool fillNextInput(Jet::jet_list_t &inputList, int start_index=0);
  virtual void moveToEventN(int n);

  void invert_input_order(bool in) {invert = in;}

protected:

  bool invert;
};

}  // namespace SpartyJet
#endif
