#ifndef _CALORIMETERSIMTOOL_HH_
#define _CALORIMETERSIMTOOL_HH_

#include "JetCore/JetTool.hh"
#include <math.h>
namespace SpartyJet { 

class Jet;

class CalorimeterSimTool : public JetTool {
public:
  CalorimeterSimTool(std::string name) : JetTool(name){};
	CalorimeterSimTool(float etaLimit,float deltaEta,float deltaPhi,bool set2PI=true);

	virtual void init(JetMomentMap *mmap) ;
	virtual void execute(JetCollection &inputJets) ;
	
	void SetEtaLimit(float etaLimit) 				{ m_minEta = -1.*etaLimit; m_maxEta = etaLimit; }
	void SetTowerSize(float eta, float phi) { m_deltaEta = eta; m_nPhi = (int)floor(2.*M_PI/phi+0.5); m_deltaPhi= 2.*M_PI/m_nPhi; }
	void GetEtaPhiBins(Jet* j,int& etaBin,int& phiBin);
	void SetZeroTo2PI(bool b) { m_useZeroTo2Pi = b; }
	//void DoSmear(bool smear) {m_doSmear = true;}

private:
	float m_minEta;
	float m_maxEta;
	float m_deltaEta;
	float m_deltaPhi;
	int   m_nEta;
	int   m_nPhi;
	bool  m_useZeroTo2Pi;
	//bool  m_doSmear;

	std::vector<std::vector<double> > m_towerEnergy;
	std::vector<std::vector<int> > 		m_towerNparticles;

};
} // end of SpartyJet namespace

#endif
