#ifndef _ECONVERSION_TOOL_HH_
#define _ECONVERSION_TOOL_HH_

#include <string>
#include "JetCore/JetTool.hh"
namespace SpartyJet { 

// Class to change Energy/Momentum units of Jets
class JetMomentMap;
class EConversionTool : public JetTool {
public:
  EConversionTool(std::string name) : JetTool(name), m_toGeV(true),m_MeV(0.001),m_GeV(1) {};
  EConversionTool(std::string name, bool toGeV) : JetTool(name), m_toGeV(toGeV),m_MeV(0.001),m_GeV(1) {};
	virtual void init(JetMomentMap *mmap);
  virtual void execute(JetCollection &inputJets);
	// Jets are assumed to be in GeV (i.e. setGeV(1.) )
  void setGeV(double unit){m_GeV=unit; m_MeV=m_GeV/1000.;}
protected:
  bool m_toGeV;
  double m_MeV;
  double m_GeV;

};
}  // namespace SpartyJet
#endif 
