#include "EtaPhiMomentTool.hh"
#include "JetCore/JetDistances.hh"
#include "JetCore/JetMomentMap.hh"
namespace SpartyJet { 

void EtaPhiMomentTool::init(JetMomentMap *mmap) {
  if(mmap != NULL){
    
    mmap->schedule_jet_moment("M2eta");
    mmap->schedule_jet_moment("M2phi");
    mmap->schedule_jet_moment("MomArea");
  }
}
void EtaPhiMomentTool::execute(JetCollection &theJets) {

  // retrieve the map of the collection :
  JetMomentMap * themap = theJets.get_JetMomentMap();
  if(themap->num_jet_moment() ==0) return;

  // retrieve position of moment in map (same for all jets):  
  int phipos= themap->get_jet_momentPos("M2phi");
  int etapos= themap->get_jet_momentPos("M2eta");
  int areapos= themap->get_jet_momentPos("MomArea");

  // Loop on all jets
  JetCollection::iterator jit = theJets.begin(); 
  JetCollection::iterator jitE = theJets.end(); 
  for(; jit!=jitE;++jit){
    
    float phi2=0,eta2=0, e=0;
    Jet * j = (*jit);
    // Loop on all constits
    Jet::constit_vect_t::iterator cit  = j->firstConstituent();
    Jet::constit_vect_t::iterator citE = j->lastConstituent();
    for(; cit != citE; ++cit){
      Jet* constit = (*cit);
      e += constit->e();
      double deta = JetDistances::deltaEta(j, constit);
      eta2 += deta*deta*constit->e();
      double dphi = JetDistances::deltaPhi(j, constit);
      phi2 += dphi*dphi*constit->e();
    }
    phi2 = sqrt(phi2/e);
    eta2 = sqrt(eta2/e);
    // for homogenous elipse : 2ndmom = a/sqrt(3)
    // so area = a*b*pi = 3*2ndmom*2ndmom*pi
    float area= 3*phi2*eta2*M_PI;
    // Set moments into map
    themap->set_jet_moment(phipos,j,phi2);
    themap->set_jet_moment(etapos,j,eta2);
    themap->set_jet_moment(areapos,j,area);
    //m_log << " eta2=" << eta2 << "   phi2="<< phi2 << std::endl;
  } // Loop on jets
  
}





void MomentArrayTestTool::init(JetMomentMap *mmap) {

  if(mmap != NULL){

    mmap->schedule_jet_moment_array("momArr");    
    mmap->schedule_event_moment_array("globArr");
  }  

}

void MomentArrayTestTool::execute(JetCollection &theJets) {

  // retrieve the map of the collection :
  JetMomentMap * themap = theJets.get_JetMomentMap();
  if(themap->num_jet_moment_array() ==0) return;


  int pos= themap->get_jet_moment_arrayPos("momArr");

  int i = 0;
  JetCollection::iterator jit = theJets.begin(); 
  JetCollection::iterator jitE = theJets.end(); 
  for(; jit!=jitE;++jit){
    Jet * j = (*jit);    
    JetMomentMap::value_store_t arr;
    arr.push_back(i+10.0);
    arr.push_back(i+100.0);
    arr.push_back(i+300.0);
    i++;
    themap->set_jet_moment_array(pos,j,arr);
  }

  // Now fill global array
  JetMomentMap::value_store_t arr;
  arr.push_back(42);
  arr.push_back(43.42);
  arr.push_back(44);
  themap->set_event_moment_array("globArr",arr);

}
}  // namespace SpartyJet
