#include "HullMomentTool.hh"
#include "cyl_geom.hh"
#include "JetCore/JetMomentMap.hh"

namespace SpartyJet { 

void HullMomentTool::init(JetMomentMap *mmap) {
  if(mmap != NULL){
    mmap->schedule_jet_moment("HullL");
    mmap->schedule_jet_moment("HullA");
  }
}
void HullMomentTool::execute(JetCollection &theJets) {

  // retrieve the map of the collection :
  JetMomentMap * themap = theJets.get_JetMomentMap();
  if (themap->num_jet_moment() ==0) return;

  // retrieve position of moment in map (same for all jets):  
  int lpos= themap->get_jet_momentPos("HullL");
  int apos= themap->get_jet_momentPos("HullA");

  // Loop on all jets
  JetCollection::iterator jit = theJets.begin(); 
  JetCollection::iterator jitE = theJets.end(); 
  for(; jit!=jitE;++jit){    
    Jet * j = (*jit);
    point_set_t constits,constits_tmp;
    point_vect_t hull;
    // Loop on all constits
    Jet::constit_vect_t::iterator cit  = j->firstConstituent();
    Jet::constit_vect_t::iterator citE = j->lastConstituent();
    for(; cit != citE; ++cit){
      Jet* constit = (*cit);
      constits_tmp.insert(point_t(constit->rapidity(), constit->phi()));
    }
    
    recenter_set(constits_tmp,constits);
    findConvexHull(constits, hull);
    // Set moments into map
    themap->set_jet_moment(lpos,j,polygon_lenght(hull));
    float a = fabs(polygon_area(hull));    
    themap->set_jet_moment(apos,j,a);
    // m_log << " lenght=" <<  << "   phi2="<< phi2 << std::endl;
  } // Loop on jets
  
}  // namespace SpartyJet
}
