#include "JetCore/JetMomentMap.hh"
#include "JetAreaCorrectionTool.hh"
namespace SpartyJet { 

void JetAreaCorrectionTool::init(JetMomentMap *mmap) 
{
  if(mmap != NULL)
	{
		if(mmap->get_event_moment_arrayPos("ptDensity") == -1)
			m_log << ERROR << "Event Moment array: ptDensity missing" << std::endl;
		else
			mmap->schedule_jet_moment("JetAreaCorr");
	}
}
void JetAreaCorrectionTool::execute(JetCollection &theJets) 
{
	// retrieve the map of the collection :
	JetMomentMap * themap = theJets.get_JetMomentMap();
	if(themap->num_jet_moment() ==0) return;
	
	if(themap->get_jet_momentPos("area") == -1)
	{
		m_log << INFO << "No area moment for this JetCollection.  Skipping JetAreaCorrection." << std::endl;
		return;
	}

	// Get event arrays
	JetMomentMap::valuearray_store_t* arrays = themap->get_event_moment_array();
	// Get ptDensity
	std::vector<float> rhoVec = arrays->at(themap->get_event_moment_arrayPos("ptDensity"));
	// Get Eta Bins
	std::vector<float> rhoBinVec = arrays->at(themap->get_event_moment_arrayPos("ptDensityBins"));

	// retrieve position of moment in map (same for all jets):  
	int posCorr= themap->get_jet_momentPos("JetAreaCorr");
	int posArea= themap->get_jet_momentPos("area");

	// Loop on all jets
	JetCollection::iterator jit = theJets.begin(); 
	JetCollection::iterator jitE = theJets.end(); 
	for(; jit!=jitE;++jit)
	{
		float corr =0.0;
		unsigned bin = GetRhoBin((*jit)->eta(),rhoBinVec);
		if(bin<rhoVec.size())
		{
			float area = themap->get_jet_moment(posArea,(*jit) );
			corr = rhoVec[bin] * area;
		}
		// Set moments into map
		themap->set_jet_moment(posCorr,*jit,corr);
	}

}

unsigned int JetAreaCorrectionTool::GetRhoBin(float eta,std::vector<float> rhoBinVec)
{
	unsigned int bin=0;
	for(;bin<rhoBinVec.size()-1;++bin)
	{
		if(eta>rhoBinVec[bin]&&eta<rhoBinVec[bin+1]) break;
	}
	return bin;
}

}  // namespace SpartyJet
					                   	                
