#include "JetSelectorTool.hh"
#include <iostream>
namespace SpartyJet { 

void JetSelectorTool::execute(JetCollection &inputJets) {
  JetCollection::iterator it = inputJets.begin();
  JetCollection::iterator itE = inputJets.end();  
  m_map = inputJets.get_JetMomentMap();

	Jet::jet_list_t tmp_list ; 
	tmp_list.reserve(inputJets.size()); 
	
	while(it != itE){ 
		if( passCut(*it) ){ 
			tmp_list.push_back( (Jet*) *it);        // ok ! 
		}
		else {
			delete *it;															// not ok; remove
		}
		
		++it; 
	} 

	inputJets.filter_in(tmp_list);   
}
  bool JetInputPdgIdSelectorTool::passCut(Jet* jet) {
    bool passes = true;
    for(unsigned int p=0;p<m_cutsI.size();p++)
      passes &= ( m_cutsI[p] != m_map->get_jet_moment("pdgId",jet) );
    return passes;
  }
}  // namespace SpartyJet
