#ifndef _JETSELECTORTOOL_HH_
#define _JETSELECTORTOOL_HH_

#include "JetCore/JetTool.hh"
namespace SpartyJet { 

class JetSelectorTool : public JetTool {
public :
  JetSelectorTool(std::string name) : JetTool(name){};
  JetSelectorTool(double cut, std::string name="selector") : JetTool(name), m_cut1(cut) {};
  JetSelectorTool(double cut1, double cut2, std::string name="selector") : JetTool(name) ,m_cut1(cut1),m_cut2(cut2) {};
  JetSelectorTool(std::vector<int> cuts, std::string name="selector") : JetTool(name) ,m_cutsI(cuts) {};

  virtual void execute(JetCollection &inputJets);
  virtual bool passCut(Jet* jet){return true;};
  
  virtual void setCut(double c){m_cut1 = c;};
  virtual void setCut2(double c){m_cut2 = c;};
  
protected:
  double m_cut1,m_cut2;
	std::vector<int> m_cutsI;
  JetMomentMap *m_map;
};


class JetPtSelectorTool : public JetSelectorTool  {
public :
  JetPtSelectorTool(std::string name="JetPtSelector"): JetSelectorTool(name){};
  JetPtSelectorTool(double pt): JetSelectorTool(pt,"JetPtSelector"){};
  virtual bool passCut(Jet* jet) {return (jet->pt()> m_cut1);}

};


class JetPtORESelectorTool : public JetSelectorTool  {
public :
  JetPtORESelectorTool(std::string name="JetPtORESelector"): JetSelectorTool(name){};
  JetPtORESelectorTool(double pt, double e): JetSelectorTool(pt,e,"JetPtORESelector"){};
  virtual bool passCut(Jet* jet) {return ( (jet->pt()> m_cut1)|| (jet->e()>m_cut2)  );}

};


class JetEtaCentralSelectorTool : public JetSelectorTool {
public :
  JetEtaCentralSelectorTool(std::string name="JetEtaCentralSelector"):JetSelectorTool(name){};
  JetEtaCentralSelectorTool(double abs_eta) : JetSelectorTool(abs_eta,-abs_eta,"JetEtaCentralSelectorTool"){}
  JetEtaCentralSelectorTool(double etamin, double etamax): JetSelectorTool(etamax, etamin,"JetEtaCentralSelectorTool"){} 
  virtual bool passCut(Jet* jet){return (jet->eta() > m_cut2) && (jet->eta()<m_cut1);}
};

class JetEtaForwardSelectorTool : public JetSelectorTool {
public :
  JetEtaForwardSelectorTool(std::string name="JetEtaForwardSelector"):JetSelectorTool(name){};
  JetEtaForwardSelectorTool(double abs_eta) : JetSelectorTool(abs_eta,-abs_eta,"JetEtaForwardSelectorTool"){}
  JetEtaForwardSelectorTool(double etamin, double etamax) : JetSelectorTool(etamax, etamin,"JetEtaForwardSelectorTool"){} 
  virtual bool passCut(Jet* jet){return (jet->eta() < m_cut2) || (jet->eta()>m_cut1);}
};

class JetInputPdgIdSelectorTool : public JetSelectorTool {
public :
  JetInputPdgIdSelectorTool(std::string name="JetInputPdgIdSelector"):JetSelectorTool(name){};
  JetInputPdgIdSelectorTool(std::vector<int> pdgIds) : JetSelectorTool(pdgIds,"JetInputPdgIdSelectorTool"){}
  virtual bool passCut(Jet* jet);
};

}  // namespace SpartyJet
#endif
