
#include <TBranch.h>
#include <iostream>
#include "AtlasInputMaker.h"

#include "JetCore/CustomMessage.hh"

namespace SpartyJet { 

namespace atlas {
  void CBNTInput::init(TTree * t) {  

    // In Atlas energy is given in MeV
    unitIsMeV();

    m_tree = t;

    m_e = 0; m_eta = 0; m_phi = 0; m_phi = 0;
    std::string s;
    s = m_prefix+"e"+m_suffix;
    t->SetBranchAddress(s.c_str(), &m_e);
    m_b_e = t->GetBranch(s.c_str());

    s = m_prefix+"phi"+m_suffix;
    t->SetBranchAddress(s.c_str(), &m_phi);
    m_b_phi = t->GetBranch(s.c_str());

    s = m_prefix+"eta"+m_suffix;
    t->SetBranchAddress(s.c_str(), &m_eta);
    m_b_eta = t->GetBranch(s.c_str());

    s = m_prefix+"nc"+m_suffix;
    t->SetBranchAddress(s.c_str(), &m_n);
    m_b_n = t->GetBranch(s.c_str());

    m_totalEvntN = m_tree->GetEntries();
    m_currentEvnt = 0;
  }



  void CBNTInput::fillInput(int eventn, Jet::jet_list_t &inputList) {
    m_tree->LoadTree(eventn);
    m_n = 0;

    m_b_n->GetEntry(eventn);
    m_b_e->GetEntry(eventn);
    m_b_phi->GetEntry(eventn);

    m_b_eta->GetEntry(eventn);
    float ee=0;
    for(int i=0; i< m_n; i++){
      double pt = (*m_e)[i]/cosh((*m_eta)[i]);
      double px = pt* cos((*m_phi)[i]);
      double py = pt* sin((*m_phi)[i]);
      double pz = pt*sinh((*m_eta)[i]);
      Jet* j = new Jet(px,py,pz,(*m_e)[i],i);    
      inputList.push_back(j);
      ee+= (*m_e)[i] ;
    }

  }



  void CBNTTruthInput::init(TTree * t) {  

    // In Atlas energy is given in MeV
    unitIsMeV();

    m_tree = t;

    m_e = 0; m_eta = 0; m_phi = 0; m_phi = 0;
    std::string s;
    s = m_prefix+"PtGen"+m_suffix;
    t->SetBranchAddress(s.c_str(), &m_e);
    m_b_e = t->GetBranch(s.c_str());

    s = m_prefix+"PhiGen"+m_suffix;
    t->SetBranchAddress(s.c_str(), &m_phi);
    m_b_phi = t->GetBranch(s.c_str());

    s = m_prefix+"EtaGen"+m_suffix;
    t->SetBranchAddress(s.c_str(), &m_eta);
    m_b_eta = t->GetBranch(s.c_str());

    s = m_prefix+"MGen"+m_suffix;
    t->SetBranchAddress(s.c_str(), &m_mass);
    m_b_mass = t->GetBranch(s.c_str());
  
    s = m_prefix+"Type"+m_suffix;
    t->SetBranchAddress(s.c_str(), &m_type);
    m_b_type = t->GetBranch(s.c_str());

    s = m_prefix+"GenStat"+m_suffix;
    t->SetBranchAddress(s.c_str(), &m_stat);
    m_b_stat = t->GetBranch(s.c_str());

    m_totalEvntN = m_tree->GetEntries();
    m_currentEvnt = 0;
  }


  void CBNTTruthInput::fillInput(int eventn, Jet::jet_list_t &inputList) {
    m_tree->LoadTree(eventn);
    m_n = 0;

    m_b_mass->GetEntry(eventn);
    m_b_type->GetEntry(eventn);
    m_b_e->GetEntry(eventn);
    m_b_phi->GetEntry(eventn);
    m_b_stat->GetEntry(eventn);
    m_b_eta->GetEntry(eventn);

    m_n = m_e->size();
    int ins=0;
    for(int i=0; i< m_n; i++){
      double pt = (*m_e)[i];
      double p2 = pt * cosh((*m_eta)[i]); p2 *=p2;
      double e  = sqrt(p2 + (*m_mass)[i]*(*m_mass)[i]);
      double px = pt* cos((*m_phi)[i]);
      double py = pt* sin((*m_phi)[i]);
      double pz = pt*sinh((*m_eta)[i]);
      long type = (*m_type)[i];
      long stat = (*m_stat)[i];
      if(isgenInteracting(type,stat)){
	Jet* j = new Jet(px,py,pz,e,ins); ins++;    
	inputList.push_back(j);
      }

    }
    
  }
  
  bool CBNTTruthInput::isgenInteracting(long pdg_id, long status){
    bool test =  (
		  
		  (
		   ((status%1000 == 1) ||
		    (status%1000 == 2 && status > 1000) || 
		    1 //	    (status==2 && vertex_barcode<-200000)
		    ) && 
		   // (barcode<200000)) &&      
		   !(pdg_id==12 || pdg_id==14 || pdg_id==16 ||
		     (pdg_id==1000039 &&  status%1000==1 ) ||
		     (pdg_id==1000022 &&  status%1000==1 ))
		   
		   )
		  );
    return test;
    
  }

  void PrivateTruthInput::init(TTree * t) {  
    m_tree = t;
    
    // In Atlas, energy id given in MeV
    unitIsMeV();
    
    std::string s;
    s = m_prefix+"E"+m_suffix;
    t->SetBranchAddress(s.c_str(), &m_e);
    m_b_e = t->GetBranch(s.c_str());

    s = m_prefix+"Pt"+m_suffix;
    t->SetBranchAddress(s.c_str(), &m_pt);
    m_b_pt = t->GetBranch(s.c_str());

    s = m_prefix+"Phi"+m_suffix;
    t->SetBranchAddress(s.c_str(), &m_phi);
    m_b_phi = t->GetBranch(s.c_str());

    s = m_prefix+"Eta"+m_suffix;
    t->SetBranchAddress(s.c_str(), &m_eta);
    m_b_eta = t->GetBranch(s.c_str());

    s = m_prefix+"N"+m_suffix;
    t->SetBranchAddress(s.c_str(), &m_n);
    m_b_n = t->GetBranch(s.c_str());

    m_totalEvntN = m_tree->GetEntries();
    m_currentEvnt = 0;
    std::cout <<  " inited tree "<<m_totalEvntN   << std::endl;
  }

  void PrivateTruthInput::fillInput(int eventn, Jet::jet_list_t &inputList) {
    m_tree->LoadTree(eventn);
    m_n = 0;

    m_b_n->GetEntry(eventn);
    m_b_e->GetEntry(eventn);
    m_b_phi->GetEntry(eventn);
    m_b_pt->GetEntry(eventn);
    m_b_eta->GetEntry(eventn);
    
    for(int i=0; i< m_n; i++){
      double pt = m_pt[i];
      double px = pt* cos(m_phi[i]);
      double py = pt* sin(m_phi[i]);
      double pz = pt*sinh(m_eta[i]);
      Jet* j = new Jet(px,py,pz,m_e[i],i);    
      inputList.push_back(j);
    }

  }

  
};

}  // namespace SpartyJet

