#include "ConeFinderTool.h"
namespace SpartyJet { 

namespace atlas {
  
  float get_constit_sum(Jet* j){    
    Jet::constit_vect_t::iterator it = j->firstConstituent();
    Jet::constit_vect_t::iterator itE = j->lastConstituent();
    float e=0;
    for(; it != itE; ++it) e+= (*it)->e();
    return e;
  }
  
  void ConeFinderTool::set_config(double r, double seedPt, double f){
    
    m_conefinder.m_coneR = r;
    m_conefinder.m_seedPt = seedPt;
    m_splitmerge.m_f = f;
  }

  void ConeFinderTool::execute(JetCollection &inputJets){

    // Prevent problems with empty events :
    if (inputJets.size() == 0) return ;
    
    m_conefinder.execute(inputJets);
    m_log << " before splitmerge  " << inputJets.size() << std::endl;
    //Jet* j = (*inputJets.begin());
    m_splitmerge.execute(&inputJets);    
    


  }
  
}  // namespace SpartyJet
};
