// emacs this is -*-C++-*-
#ifndef ATLAS_CONEFINDER_H
#define ATLAS_CONEFINDER_H

#include "JetConeFinderTool.h"
#include "JetSplitMergeTool.h"
#include "JetCore/JetTool.hh"
namespace SpartyJet { 

namespace atlas {  
  
  class ConeFinderTool : public JetTool {
  public:
    ConeFinderTool(std::string name = "myConeTool") : JetTool(name){set_config(0.7,1,0.75);};
    virtual void execute(JetCollection &inputJets);
    
    void set_config(double r, double seedPt, double f);
    
    double getConeRadius() {return m_conefinder.m_coneR;}
    
  protected:
    
    JetConeFinderTool m_conefinder;
    JetSplitMergeTool m_splitmerge;
    
  };
  
};
}  // namespace SpartyJet
#endif
