// emacs this is -*-C++-*-
#ifndef FASTKTJET_KTHULL_H
#define FASTKTJET_KTHULL_H

#include "JetTools/cyl_geom.hh"
#include "FastKtUtils.h"
#include "FastKtParam.h"

//************************************************************
/// Experimental jet finder
//************************************************************
namespace SpartyJet { 

namespace FastKtJet {

  // ************************************************************************
  class KtHullInfo : public KtJetInfo {
  public:
    KtHullInfo(Jet* vec): KtJetInfo(vec){m_radius=-1;};
    virtual ~KtHullInfo(){};
    point_list_t m_hull;
    float getRadius(){ 
      if(m_radius<0) {
	m_radius = max_deltaR(point_t(eta,phi),m_hull);
      }
      return m_radius;
    }
  protected:
    float m_radius;
  };
  // ************************************************************************

  // ************************************************************************  
  class KtAlgoHull : public KtAlgoStandard {
  public:
    KtAlgoHull(double rp = 1.5);
    virtual void init(jetcollection_t *constituents) ;
    virtual bool continueClustering();
    virtual void endClustering();
    bool doMergeJet(KtHullInfo* j1, KtHullInfo* j2, point_list_t &newhull,float &phicenter );
    
    virtual void setProperty(std::string name,float val);
    void setDistanceType(KtDistance::KtDistanceType /*distType*/) {KtAlgoStandard::setDistanceType(KtDistance::Angular);}
  protected:
    void processStep();
    void secondPass();
    int m_N;
    float m_Rmin, m_ConeMin,m_ConeMax;
    float testR(int n) {int d=n/4 ; return m_Rmin+10*exp(-d*m_rParameterSq);}
    bool m_secondpass;
    bool m_do2steps;
  };
  // ************************************************************************

  // ************************************************************************
  class KtListHull : public KtLists {
  public:
    KtListHull(jetcollection_t *, KtDistance *, KtRecom *recom, bool reversed_mode =false);
    virtual ~KtListHull(){};
    virtual void buildKtJetInfo(jetcollection_t *jetColl);
    void buildKtJetInfoPass2(KtJetInfo_list *jetlist);
  };
  // ************************************************************************    
};

}  // namespace SpartyJet
#endif
