#include "FastKtUtils.h"
#include "FastKtJet.h"
#include <vector>
#include <utility>
#include <iostream>
#include <string>
#include <algorithm>
#include <cmath>

namespace SpartyJet { 

namespace FastKtJet {

  void dump_info(KtJetInfo* ji){

    std::cout << ji->index << "  ";
    std::list<Jet *>::iterator itB = ji->constit_list.begin();
    std::list<Jet *>::iterator itE = ji->constit_list.end();
    for(;itB!=itE;++itB){
      std::cout <<"("<< (*itB)->getConstituentNum()
		<< "," << (*itB)->index()<<") ";
    }
    std::cout << std::endl;

    
  }

  /** Constructor  */
  
  KtEvent::KtEvent(jetcollection_t * constituents, KtAlgo* thektAlg){
    
    m_ktAlgo = thektAlg;
    m_constituents = constituents;
    
    static bool first_time = true;    
    if(first_time) {printSteering("default"); first_time = false;}
  }

  /** Destructor */
  KtEvent::~KtEvent() {
    // clear all remaining KtJetInfo in the list
    KtJetInfo_iterator it_list  = m_jetInfoList.begin();
    KtJetInfo_iterator it_listE  = m_jetInfoList.end();
    for(; it_list != it_listE; ++it_list){
      delete (*it_list);
    }
    it_list  = m_rejectedjetInfoList.begin();
    it_listE  = m_rejectedjetInfoList.end();
    for(; it_list != it_listE; ++it_list){
      delete (*it_list);
    }
    
  }



  /*********************
   *  Private methods  *
   *********************/
  
  // **********************************************************************************
  void KtEvent::init(){
    m_ktAlgo->setJetCollection(&m_jetInfoList, &m_rejectedjetInfoList);
    m_ktAlgo->init(m_constituents);
  }

  // **********************************************************************************
  void KtEvent::makeJets() {
    /// This performs the usual Kt procedure :
    /// Merging or extracting jets and ending the procedure
    /// is governed by the KtAlgo
    int nParticles = m_constituents->size();
    m_dMerge.resize(nParticles);              // Reserve space for D-cut vector
    m_hist.resize(nParticles);                // Reserve space for merging history vector
    //std::cout << " makeJets2   m_ktalgo" << m_ktAlgo->name() << "  size = "<< nParticles <<std::endl; 
    int njet = nParticles;
    while(m_ktAlgo->continueClustering()){
      // All operations are done by KtAlgos
      // we only retrieve information      
      if(m_ktAlgo->doExtractJet()) {
	m_hist[njet-1] = m_ktAlgo->getLastJetIndex();
	m_dMerge[njet-1] = m_ktAlgo->getLastDJet();
	//dump_info(m_ktAlgo->getExtractJet());
      } else{
	m_hist[njet-1] = -(m_ktAlgo->getLastJetIndex()*nParticles+m_ktAlgo->getLastJetIndex2());
	m_dMerge[njet-1] = m_ktAlgo->getLastDPair();
      }
      if(njet>1) njet--;
    }
    m_ktAlgo->endClustering();

  }

  
  // **********************************************************************************
  void KtEvent::addEnergy() {
    m_eTot = 0;
    jetcollection_t::const_iterator itr;
    for (itr = m_constituents->begin(); itr != m_constituents->end(); ++itr) {
      m_eTot += (*itr)->e();          // Add up energy in event
    }
  }



  void KtEvent::printSteering(std::string /*mode*/) const {
    //static std::string collisionType[4] = {"e+e-","ep","pe","pp"};
    std::cout << "******************************************\n";
    std::cout << " Using Atlas FastKt Jet !!!! " << std::endl;    
    std::cout << "******************************************\n";
  }


}  // namespace SpartyJet
}//end of namespace

