#ifndef FASTKTJET_KTEVENT_H
#define FASTKTJET_KTEVENT_H

#ifndef STD_VECTOR_H
#include <vector>
#define STD_VECTOR_H
#endif

#ifndef STD_STRING_H
#include <string>
#define STD_STRING_H
#endif

#include "FastKtUtils.h"

//#include "JetAlgToolBase.h"
namespace SpartyJet { 

namespace FastKtJet {


/**
 * The KtEvent class represents a whole system
 * of Jets constructed using 
 * the defined KT clustering algorithm.
 *
 * strongly inspired from the KtJet package
 
 @author Pierre-Antoine Delsart
*/


  class KtEvent {
  public:
    /**  constructors */
    KtEvent(jetcollection_t *, KtAlgo *thektalg);
    
    /** Destructor */
    ~KtEvent();
    

    /** init */
    void init();
    /** Make jets */
    void makeJets();
    



    /** Get pointers to input particles */
    jetcollection_t* getConstituents() const {return m_constituents;};

    /** Get the list of final jets (in the form of a KtJetInfo list)*/
    const KtJetInfo_list * getJetInfoList() {return &m_jetInfoList;}
    /** Get the list of rejected jets (in the form of a KtJetInfo list)*/
    const KtJetInfo_list * getRejectedJetInfoList() {return &m_rejectedjetInfoList;}


    /** Get total energy in event */
    inline float getETot() const;

    inline KtAlgo * getKtAlgo(){return m_ktAlgo;};

    // Used to check history of merging process
    inline int getHistory(int i){return m_hist[i];};
    inline float getHistoryD(int i){return m_dMerge[i];};

    /** d-cut where n+1 jets merged to n */
    //inline float getDMerge(int nJets) const;

    /// Set Reversed Kt
    void setReversedKt(bool flag){m_reversedKt = flag;}
    bool isReversedKtMode() const {return m_reversedKt;}

  private:
 
    /** Copy of original input particles */
    jetcollection_t*  m_constituents;



    KtAlgo * m_ktAlgo;

    /* Collision type  -- obsolete here it is pp */
    int m_type;


    /** R parameter squared */
    float m_rParameterSq;
    /** Total energy in event */
    float m_eTot;

    // Reversed Kt ?
    bool m_reversedKt;

    /** Jets found */
    KtJetInfo_list  m_jetInfoList;
    KtJetInfo_list  m_rejectedjetInfoList;


    /** merging history - jet/pair merged at each step */
    std::vector<int> m_hist;
    /** d at each merge */
    std::vector<float> m_dMerge;



    /** Add up E and Et in event */
    void addEnergy();

    /** Print steering parameters to stdout */
    void printSteering(std::string mode="") const;
  };



  inline float KtEvent::getETot() const {return m_eTot;}


}//end of namespace

}  // namespace SpartyJet
#endif
