#include "FastKtTool.h"


#include "FastKtJet.h"
#include "FastKtUtils.h"
#include "JetCore/CommonUtils.hh"

#include <iostream>
namespace SpartyJet { 

namespace atlas {
  // ******************************************************************
  int FastKtTool::translateDistName(std::string distname){
    std::map<std::string , int> map_name;
    map_name["DeltaR"]   = FastKtJet::KtDistance::DeltaR ;
    map_name["Angular"]  = FastKtJet::KtDistance::Angular ;
    map_name["Reversed"] = FastKtJet::KtDistance::Reversed;

    
    return translateName(map_name, distname, "distance");
  }
  int FastKtTool::translateRecomName(std::string recomname){
    std::map<std::string , int> map_name;
    map_name["E"] =   FastKtJet::KtRecom::E ;
    map_name["Pt"]  = FastKtJet::KtRecom::Pt ;
    
    return translateName(map_name, recomname, "recom");
  }
  int FastKtTool::translateAlgoName(std::string algoname){
    std::map<std::string , int> map_name;
    map_name["Standard"]       = FastKtJet::KtAlgo::Standard;
    map_name["Aachen"]         = FastKtJet::KtAlgo::Aachen ;
    map_name["Reversed"]       = FastKtJet::KtAlgo::Reversed ;
    map_name["StandardExcluN"] = FastKtJet::KtAlgo::StandardExcluN  ;
    map_name["StandardExcluD"] = FastKtJet::KtAlgo::StandardExcluD  ;
    map_name["Hull"]           = FastKtJet::KtAlgo::Hull;    
    return translateName(map_name, algoname, "algorithm");
  }


  // ******************************************************************
  void FastKtTool::simple_config(std::string findername, double param){

    int code = translateAlgoName(findername);
    if (code==-1) return ;
    m_rParameter = param;
    if(m_ktAlgo) delete m_ktAlgo; // delete previous KtAlgo, since this is the only pointers to this object
    m_ktAlgo = FastKtJet::getKtAlgo(code,param);
    //std::cout << "  ATLAS FastKt : Got Kt Alg " << m_ktAlgo->name() << "  code " << code << std::endl;   
  
  
  }
  // ******************************************************************
  void FastKtTool::set_exclusiveN(int n){
    FastKtJet::KtAlgoStandardExclN * a = dynamic_cast<FastKtJet::KtAlgoStandardExclN*>(m_ktAlgo);
    if(a) a->setNJet(n);
  }

  void FastKtTool::set_exclusiveD(double ycut){
    FastKtJet::KtAlgoStandardExclD * a = dynamic_cast<FastKtJet::KtAlgoStandardExclD*>(m_ktAlgo);
    if(a) a->setYCut(ycut);

  }
  
  // ******************************************************************
  void FastKtTool::execute(JetCollection &theJets){

    // protect against pathological case :
    if(theJets.size()==0) return ;
  	
		JetCollection tmp_list;
  
		// retrieve the map of the collection :
  	JetMomentMap * themap = tmp_list.get_JetMomentMap();
		// Copy Jet moment layout from input
		themap->copy_structure(*(theJets.get_JetMomentMap()));

    ///////////////////
    // Build Kt Jets //
    ///////////////////
    FastKtJet::KtEvent ktBuilder(&theJets, m_ktAlgo);
    ktBuilder.init();
    ktBuilder.makeJets();

    //int insize = theJets.size();
    /////////////////////////////
    // Convert Kt Jets to Jets //
    /////////////////////////////
  
    // retrieve and check output from Kt 
    const FastKtJet::KtJetInfo_list * infolist = ktBuilder.getJetInfoList() ;
    //std::cout << " got info list =  "<< infolist << std::endl;
    //std::cout << " got info list size =  "<< infolist->size() << std::endl;
  
    // get a pointer to the end :  
    JetCollection::iterator inputE = theJets.end(); inputE--;

    // Do a reverse loop to sort by decreasing pt (in standard mode) :
    FastKtJet::KtJetInfo_list::const_reverse_iterator infoIt = infolist->rbegin();
    FastKtJet::KtJetInfo_list::const_reverse_iterator infoItE = infolist->rend();

    int nConstit = 0;
    float eT1=0, eT2=0, eT3=0;
    for( ; infoIt != infoItE; ++infoIt){

      Jet* aJet = new Jet();
      // retrieve Kt jet constituents
      eT1 += (*infoIt)->hlv.e();
      std::list<Jet*>::iterator itconst = (*infoIt)->constit_list.begin();
      std::list<Jet*>::iterator itconstE = (*infoIt)->constit_list.end();
      for( ; itconst != itconstE; ++itconst){
	aJet->addJet((*itconst));
	eT2 += (*itconst)->e();
	nConstit++;
      }

      //aJet->set4Mom((*infoIt)->hlv);
      eT3 += aJet->e();
      tmp_list.push_back(aJet);
    }

    // Now clear  containing input :
    //inputE++;
    //clear_list(theJets, theJets.begin(), inputE);    
    clear_list(theJets);
    theJets = tmp_list; // recopy
    
    
    //std::cout  << " re-found nconstit = "<< nConstit << "   initial size="<< insize << "   njets = "<< theJets.size()<<std::endl;
    //std::cout  << " esums = "<<eT1 << "  " <<eT2 << "  " <<eT3 << "  " << std::endl;


  }

  // ******************************************************************
  // Tool Control //
  // ******************************************************************
  int FastKtTool::translateName(std::map<std::string,int> & nmap, std::string thename, std::string type){
    std::map<std::string , int>::iterator it = nmap.find(thename);
    std::map<std::string , int>::iterator itE = nmap.end();
    if (it == itE){
      std::cout << " ATLAS FastKt : Unknown kt "<< type << " : "<< thename << std::endl;
      std::cout << " Choose one of : ";
      for(it = nmap.begin(); it!=itE;++it){
	std::cout << (*it).first <<  "  ";
      }
      std::cout << std::endl;
      return -1;
    }
    return (*it).second;  
  }

}  // namespace SpartyJet
}
