// emacs this is -*-C++-*-
#ifndef ATLAS_FASTKTJET_H
#define ATLAS_FASTKTJET_H

#include "FastKtParam.h"
#include "JetCore/JetTool.hh"
#include <map>

namespace SpartyJet { 

namespace atlas {
  class FastKtTool : public JetTool {
  public :
    FastKtTool(std::string name = "myFastKt") : JetTool(name), m_ktAlgo(NULL){simple_config("Standard",0.7) ;};

    virtual void execute(JetCollection &inputJets);
    
    void simple_config(std::string findername, double param);

    void set_other_propery(std::string name, float val){m_ktAlgo->setProperty(name,val);}
    // if running exclusive mode with fixed Jet num :
    void set_exclusiveN(int N);
    // if running exclusive mode with fixed y cut:
    void set_exclusiveD(double ycut);
  
    double getConeRadius() {return m_rParameter;}
    
  protected:

    // the algo config :
    FastKtJet::KtAlgo * m_ktAlgo;

    // algorithm parameters and flags
    double m_rParameter;              // R parameter
    int m_excluN;
    double m_excluD;
  

    //////////////////
    // Tool Control //
    //////////////////

    bool m_configOK;

    int translateAlgoName(std::string algoname);
    int translateDistName(std::string algoname);
    int translateRecomName(std::string algoname);
    int translateName(std::map<std::string,int> & nmap, std::string name, std::string type);

  };

}
}  // namespace SpartyJet
#endif
