#include "FastKtUtils.h"
#include "JetCore/JetDistances.hh"

//#include "AthenaKernel/getMessageSvc.h"
//#include "GaudiKernel/MsgStream.h"

#include <string>
#include <iostream>
namespace SpartyJet { 

namespace FastKtJet {

  // Neighbourhood -------------------------------------------------

  inline bool KtNNOperation::lineExcluded(bool i, float eta, float phi){
    return (m_d[i].cx*eta + m_d[i].cy*phi < m_d[i].cc - 0.001); // +0.001 : to avoid pbm if several points are equidistant
  }
  inline float KtNNOperation::lineExcludedV(bool i, float eta, float phi){
    return (m_d[i].cx*eta + m_d[i].cy*phi - m_d[i].cc);
  }
  inline bool KtNNOperation::isClosest(float eta, float phi){
    return ( (eta*eta+phi*phi) < m_minD );
  }
  inline float KtNNOperation::translatePhi(float phi){

    float phit = phi - m_phiRef;
    //std::cout<< " Translating with  "<< m_phiRef << "   |  " << phi  << " ->  " << phit << std::endl;
    if(phit < -3.14159265)  {return (phit+6.2831853);}
    if (phit < 3.14159265) {return phit;}
    else {return (phit - 6.2831853);}
  }
  void KtNNOperation::update_lines(bool i, float eta, float phi, bool dosym ){
    // Update the exclusions line using point at (eta,phi)
    // if dosym : also calculate the pi-shifted line

    float cx = m_etaRef - eta  ;
    float cy = - phi ;
    bool ni = !i;
    // update line parameters : 
    m_d[i].cx = cx; m_d[i].cy = cy; m_d[i].cc = 0.5*(m_etaRef*m_etaRef - eta*eta - phi*phi);
    if(dosym && (cy != 0.) ) {
      m_d[ni].cx = cx; m_d[ni].cy = -cy; 
      m_d[ni].cc = (phi>0) ? m_d[i].cc - 2*cy*(phi - 3.14159265) : m_d[i].cc - 2*cy*(phi + 3.14159265); 
      m_needline = false;
    }
  }



  void KtNNOperation::insertPoint(KtJetInfo_iterator  jet){
    initPoint(jet);
    findNNrelation(jet,false);
    (*jet)->closest_neighb = computeNN(jet);
  }
  void KtNNOperation::removePoint(KtJetInfo_iterator  jet){
    initPoint(jet);
    findNNrelation(jet,true);
  }
  void KtNNOperation::removePoint(KtJetInfo_iterator  jet1, KtJetInfo_iterator  jet2){
    initPoint(jet1);
    findNNrelation(jet1,true);
    //m_points_toupdate.remove(jet2);
    m_etaRef = (*jet2)->eta;
    m_phiRef = (*jet2)->phi;
    m_minD = 10000;
    m_needline = true;
    m_d[0].cx = 0 ;    m_d[0].cy = 1 ;     m_d[0].cc = -10 ;
    m_d[1].cx = 0 ;    m_d[1].cy = 1 ;     m_d[1].cc = -10 ;
    findNNrelation(jet2,true);
    //m_points_toupdate.remove(jet1);
  }


  void KtNNOperation::initPoint(KtJetInfo_iterator  jet, bool doclear){
    m_etaRef = (*jet)->eta;
    m_phiRef = (*jet)->phi;
    m_minD = 10000;
    m_needline = true;
    if(doclear) m_points_toupdate.clear();
    m_d[0].cx = 0 ;    m_d[0].cy = 1 ;     m_d[0].cc = -10 ;
    m_d[1].cx = 0 ;    m_d[1].cy = 1 ;     m_d[1].cc = -10 ;
  }

  KtJetInfo_iterator KtNNOperation::computeNN(KtJetInfo_iterator jet){
    KtJetInfo_iterator itB = m_allpoints->begin();
    KtJetInfo_iterator itE = m_allpoints->end();
    KtJetInfo_iterator it = jet;

    //std::cout << "computeNNP" << std::endl;    
    m_NN = jet;
    m_minD = 10000;
    float etajet = (*jet)->eta;
    bool cond = true && (it != itB);
    // ***** Begin to search below ******
    // **** !! This assume an eta-sorted list !! ******
    --it;
    while(cond){
      float deta = (*it)->eta - etajet;
      if( deta*deta > m_minD) {
	break; // we won't find neighbour anymore
      }else {
	float d = m_dist->geodist( *it , *jet);
	if(d <m_minD){
	  m_minD = d;
	  m_NN = it;
	}
      }	
    
      cond =  (it != itB) ;
      --it;
    }
    // reinit params :
    it = jet;
    ++it;    
    cond =   (it != itE) ;
    // ***** Begin to search above ******
    while(cond){
      float deta = (*it)->eta - etajet;
      if( deta*deta > m_minD) {
	break; // we won't find neighbour anymore
      }else {
	float d = m_dist->geodist( *it , *jet);
	if(d <m_minD){
	  m_minD = d;
	  m_NN = it;
	}
      }	
      ++it;
      cond =  (it != itE) ;          
    }    
    return m_NN;
  }

  void KtNNOperation::findNNrelation(KtJetInfo_iterator jet,  bool removingMode ){

    KtJetInfo_iterator itB = m_allpoints->begin();
    KtJetInfo_iterator itE = m_allpoints->end();
    KtJetInfo_iterator it = jet;
    //std::cout << "findNNrelation" << std::endl;
    bool needList = true && (it != itB) ;

    // ***** Begin to search below ******
    // **** !! This assume an eta-sorted list !! ******
    --it;
    while(needList){
      float phi = translatePhi((*it)->phi);
      bool islsup = (phi < 0);
      if( !lineExcluded( islsup ,(*it)->eta,phi) ){ // we'll have to update line number 'islsup'.
	update_lines(islsup,(*it)->eta,phi,m_needline);
	
	if( removingMode && (jet == (*it)->closest_neighb) ) {
	  m_points_toupdate.push_back(it);
	} else {
	  float dtoNN =  m_dist->geodist( *it , (*(*it)->closest_neighb));
	  float dtoRef = m_dist->geodist(*it, *jet);
	  if(dtoRef < dtoNN ) { // Studied point (=jet) is the closest Neigb of (*it)
	    m_points_toupdate.push_back(it);
	    (*it)->closest_neighb = jet;
	  }
	} // end if tracemode
	
      }else { // is not excluded by regular line
	needList = !lineExcluded( !islsup ,(*it)->eta,phi) ; // if also excluded by other line then needList=false ...
      }
      needList = needList  && (it != itB) ;
      --it;
    }

    // *** Re-init parameters for above search. ***
    it = jet;
    ++it;
    needList = true && (it != itE) ;
    m_d[0].cx = 0 ;    m_d[0].cy = 1 ;     m_d[0].cc = -10 ; // we need to reinit the 1st line
    m_d[1].cx = 0 ;    m_d[1].cy = 1 ;     m_d[1].cc = -10 ; // we need to reinit the 1st line
    m_needline = true;
    // ***** Begin to search above ******
    while(needList){
      float phi = translatePhi((*it)->phi);
      bool islsup = (phi > 0);
      
      if( !lineExcluded(islsup,(*it)->eta,phi) ){ // we'll have to update line islsup.
	update_lines(islsup,(*it)->eta,phi,m_needline);
	
	if( removingMode && (jet == (*it)->closest_neighb) ) {
	  m_points_toupdate.push_back(it);
	} else {
	  float dtoNN =  m_dist->geodist( *it , (*(*it)->closest_neighb));
	  float dtoRef = m_dist->geodist(*it, *jet);
	  if(dtoRef < dtoNN ) { // current point is the closest Neigb of (*it)	    
	    m_points_toupdate.push_back(it);
	    (*it)->closest_neighb = jet;
	  }
	}
	
      }else {
	needList = !lineExcluded( !islsup ,(*it)->eta,phi) ; // if also excluded by other line then needList=false ...
      }
      ++it;
      needList = needList  && (it != itE) ;    
    }

  }

  


  //   --------------------------------------------------------------------------
  // Kt Lists  --------------------------------------------------------------------------
  //    --------------------------------------------------------------------------

  KtLists::KtLists(jetcollection_t * p, KtDistance *ktdist, KtRecom *recom, bool reversed_mode)
    :  m_fKtDist(ktdist), m_ktRecom(recom) {
    
    //std::cout  << "KtLists::KtLists initial jet collection size = "<< p->size() <<  std::endl;
    KtNNOperation *tt = new KtNNOperation();
    m_NNoperator = (KtNNOperation*) tt;
    m_reversedMode = reversed_mode;
    buildKtJetInfo(p);
  }

  KtLists::~KtLists() {
    delete m_NNoperator;
  }




  /***************************************************************
   *  Merge jets i and j, updating four-momentum and all lists   *
   ***************************************************************/
  void KtLists::mergeJets(KtJetInfo_iterator jeti, KtJetInfo_iterator jetj) {
  
    //std::cout << "  Merging  " << (*jeti)->index << " -  " << (*jetj)->index  << std::endl;

    // Deal with special ending case -------------------------------------------
    if(m_nRemaining <= 3){ // This is a special case
      // recombine j into i :
      m_ktRecom->combine(*jeti, *jetj);
      // remove jetj from m_diList and m_dijList: 
      m_diList.erase((*jetj)->pos_in_diList); 
      m_dijList.erase((*jetj)->pos_in_dijList);
      // Now actually remove jetj :
      KtJetInfo * ktifj = (*jetj);
      // The associated Jet won't be associated so delete it 
      //delete ktifj->ktlv;
      delete ktifj;
      m_ktlist.erase(jetj);
      // nothing else needs to be done !!
      if(m_nRemaining==3) {
	m_diList.erase((*jeti)->pos_in_diList);
	m_dijList.erase((*jeti)->pos_in_dijList);
	KtJetInfo_iterator jetk = m_ktlist.begin();  // get last jet in list
	if (jetk == jeti) ++jetk;
	m_dijList.erase((*jetk)->pos_in_dijList);

	(*jetk)->closest_neighb = jeti;
	(*jeti)->closest_neighb = jetk;

	float dGi = (*m_fKtDist)(*jeti, *jetk); // compute NN distance	
	(*jetk)->pos_in_dijList = insertValueAndIter(m_dijList, dGi, jetk); // reinsert k
	(*jeti)->pos_in_dijList = insertValueAndIter(m_dijList, dGi, jeti); // reinsert i
	(*jeti)->pos_in_diList  = insertValueAndIter(m_diList, (*m_fKtDist)(*jeti),  jeti);
      }

      m_nRemaining--;
      return;
    }
    // end special ending case -------------------------------------------


    // First find list of jets needing update after the removal of i and j :
    m_NNoperator->removePoint(jeti,jetj);
    // copy this list of points :
    std::list<KtJetInfo_iterator> points_toupdate;
    std::list<KtJetInfo_iterator>::iterator it = m_NNoperator->m_points_toupdate.begin();
    std::list<KtJetInfo_iterator>::iterator itE = m_NNoperator->m_points_toupdate.end();
    for(; it != itE; ++it){
      if( (*it != jeti ) && (*it != jetj) ) {
	points_toupdate.push_back(*it);
      }
    }

    // recombine j into i :
    m_ktRecom->combine(*jeti, *jetj);

    // remove jetj from m_diList and m_dijList: 
    m_diList.erase((*jetj)->pos_in_diList); 
    m_dijList.erase((*jetj)->pos_in_dijList);

    // remove jeti from m_diList and m_dijList (and keep hint because we'll need reinsertion): 
    KtDist_map::iterator hint_diList = (*jeti)->pos_in_diList ; 
    if(hint_diList != m_diList.begin() )  hint_diList--; else ++hint_diList;
    m_diList.erase((*jeti)->pos_in_diList);
    
    m_dijList.erase((*jeti)->pos_in_dijList ); // dont keep hint for this one as it may be removed in next steps


    // Now actually remove jetj :
    KtJetInfo * ktifj = (*jetj);
    // This jetinfo will never be used again so delete it 
    delete ktifj;
    m_ktlist.erase(jetj);

    // get hint for jeti in m_ktlist
    KtJetInfo_iterator hint_ktlist = jeti;
    if(hint_ktlist == m_ktlist.begin()) ++hint_ktlist;
    else --hint_ktlist;
    // remove jeti from list. Will be reinserted
    KtJetInfo *newJ = *jeti;
    m_ktlist.erase(jeti);

    
    // now we need to recalculate NN of  every points that changed because of removal 
    it  = points_toupdate.begin();
    itE = points_toupdate.end();
    for(; it != itE; ++it){
      KtJetInfo_iterator updatedJet = (*it) ;
      (*updatedJet)->closest_neighb =  m_NNoperator->computeNN(updatedJet);

      // remove it from m_DGi list (keeping hint) ...
      KtDist_map::iterator hint = (*updatedJet)->pos_in_dijList ; 
      if(hint != m_dijList.begin() ) hint--; else ++hint; 
      m_dijList.erase((*updatedJet)->pos_in_dijList );
      // ... and reinsert it with new value
      float dGi = (*m_fKtDist)((*updatedJet), *(*updatedJet)->closest_neighb); // compute NN distance
      (*updatedJet)->pos_in_dijList = insertValueAndIter_withHint(m_dijList, dGi, updatedJet, hint); // reinsert it	
    }

    // reinsert combined jet in the eta sorted ktlist : 
    // first, find the right place in eta-sorted list
    KtJetInfo_iterator insertplace = hint_ktlist;
    if( newJ->eta <  (*insertplace)->eta ) {
      while( insertplace != m_ktlist.begin() ){
	--insertplace;
	if( newJ->eta >=  (*insertplace)->eta ){
	  // we found the place !
	  ++insertplace;
	  break;
	}
      }
    } else if( newJ->eta >  (*insertplace)->eta ) {
      ++insertplace;
      while( insertplace != m_ktlist.end() ){
	if( newJ->eta <=  (*insertplace)->eta ){
	  // we found the place !
	  break;
	} else 	++insertplace;
      }
    }

    // Actual reinsertion in the ktlist
    insertplace = m_ktlist.insert(insertplace, newJ);      

    // Recalculate new jeti NN stuff : 
    m_NNoperator->insertPoint(insertplace);
    
    // we need to deal with all points that have been updated by the insertion
    it  = m_NNoperator->m_points_toupdate.begin();
    itE = m_NNoperator->m_points_toupdate.end();
    KtDist_map::iterator hint_dijList = m_dijList.begin();
    float minDgi = 10.E20;
    for(; it != itE; ++it){
      KtJetInfo_iterator updatedJet = (*it) ;
      
      // remove it from m_DGi list ...
      KtDist_map::iterator hint = (*updatedJet)->pos_in_dijList ; 
      if(hint != m_dijList.begin() ) hint--; else ++hint;
      m_dijList.erase((*updatedJet)->pos_in_dijList );
	// ... and reinsert it with new value
      float dGi = (*m_fKtDist)(newJ, (*updatedJet));
      (*updatedJet)->pos_in_dijList = insertValueAndIter_withHint(m_dijList, dGi , updatedJet, hint);
      if( dGi < minDgi) { minDgi = dGi; hint_dijList = (*updatedJet)->pos_in_dijList;}
    }
    
    // reinsert new jet's new ddi : 
    newJ->pos_in_diList = insertValueAndIter_withHint(m_diList, (*m_fKtDist)(newJ),  insertplace, hint_diList);
    // reinsert new jet's new dGi : 
    float dGi = (*m_fKtDist)(newJ, *newJ->closest_neighb);
    newJ->pos_in_dijList = insertValueAndIter_withHint(m_dijList,  dGi , insertplace, hint_dijList);
      
    --m_nRemaining;
    

  }


  /***************************************************
   *  Delete jet i by moving last jet on top of it,  *
   *   updating four momentum and kt vectors         *
   ***************************************************/
  void KtLists::killJet(KtJetInfo_iterator jeti) {
  
    //    std::cout << "  Killing  " << (*jeti)->index  << std::endl;    

    // First find list of jet needing update after the removal of i  :
    m_NNoperator->removePoint(jeti);

    // remove jeti from m_diList and dGi :     
    m_dijList.erase((*jeti)->pos_in_dijList);
    m_diList.erase((*jeti)->pos_in_diList);
    
    // remove jeti :
    m_ktlist.erase(jeti);
    
    
    // Update all  points affected by removal :
    std::list<KtJetInfo_iterator>::iterator it = m_NNoperator->m_points_toupdate.begin();
    std::list<KtJetInfo_iterator>::iterator itE = m_NNoperator->m_points_toupdate.end();
    for(; it != itE; ++it){
      //std::cout << "    updating   " << (*(*it))->index << std::endl;
      KtJetInfo_iterator kit = (*it) ;
      (*kit)->closest_neighb =  m_NNoperator->computeNN(kit);
      // remove it from m_DGi list ...
      KtDist_map::iterator hint = (*kit)->pos_in_dijList ; 
      if(hint != m_dijList.begin() ) hint--; else ++hint;
      m_dijList.erase((*kit)->pos_in_dijList );
      // ... and reinsert it with new value
      float dGi = (*m_fKtDist)((*kit), *(*kit)->closest_neighb);
      (*kit)->pos_in_dijList = insertValueAndIter_withHint(m_dijList, dGi, kit, hint);
    }

    --m_nRemaining;

    return;
  
  }
  
  /***************************************************
   *  Build the list of jets, list of neighbour      *
   *  lists of distances with all the cross-pointers *
   ***************************************************/
  void KtLists::buildKtJetInfo(jetcollection_t * jetColl){
  

    jetcollection_t::iterator itktv = jetColl->begin();
    jetcollection_t::iterator itktv_e = jetColl->end();
    //m_ktlist.reserve(jetColl.size());

    //std::cout.precision(9);
    //std::cout << " buildKtJetInfo  size = "<<  jetColl->size() << std::endl;

    KtJetInfo_iterator it_list ;
    bool first = true; 
    m_nRemaining = 0;
    m_ktlist.clear();
    float eTot= 0.0;
    // Fill the KtJetInfo list
    for( ; itktv != itktv_e; ++itktv){
      //Jet *j = (*itktv);
      if ( std::isnan( (*itktv)->e()) ) {	
	continue; 
      }
      
      KtJetInfo *ki = 0;
      
      try{ // take care of bad input vectors
	//std::cout << m_nRemaining << " jet e =  "<< (*itktv)->e() << std::endl;
	ki = new KtJetInfo( (*itktv)); // object created here will be deleted in mergJet or passed to other objects (throught getMinJet) which must delete them. (ex. KtEvent)
      }
      catch(...){
	//MsgStream log( Athena::getMessageSvc(), "FastKt::FastKtUtils" );
	std::cout << " Exception thrown for input vector "<< m_nRemaining <<"  (E="<< (*itktv)->e() << ", pz="<< (*itktv)->pz() << ") this vector won't be used by jet finder"<< std::endl;
	if(ki) delete ki;
	continue;
      }

      m_ktlist.push_back(ki);

      // Make sure it_list corresponds to this ki
      if(first){
	it_list = m_ktlist.begin();
	first = false;
      } else {
	++it_list;
      }

      // compute individual dist for this jet and store it
      float d_beam = (*m_fKtDist)(ki);
      ki->pos_in_diList =  insertValueAndIter(m_diList, d_beam, it_list);

      ki->index = 0 ;
      (*it_list)->index =  m_nRemaining ; 


      eTot += (*itktv)->e();
      ++m_nRemaining;
    }

    m_ktlist.sort( KtLists::KtJetInfoEtaPhiComp );

    // The sorted ktlist is done, we can init the Neighbourhood builder :
    m_NNoperator->init(&m_ktlist , m_fKtDist);
  
    // Now build the neigbours
    it_list  = m_ktlist.begin();
    KtJetInfo_iterator it_listE = m_ktlist.end() ;
    for( ; it_list != it_listE; ++it_list){
      
      KtJetInfo_iterator nb = m_NNoperator->computeNN(it_list);

      (*it_list)->closest_neighb = nb; // assign closest_neigb;

      // compute distance associated with neighbour and sort it in the dij map    
      float  dGi =  (*m_fKtDist)((*it_list), (*nb) );      
      (*it_list)->pos_in_dijList =  insertValueAndIter(m_dijList, dGi, it_list);
      int aa= (*it_list)->index; aa= m_dijList.size();
    }
    //std::cout <<  " Total E in input = " << eTot << std::endl;
  }

  





  // -----------------------------------------------------------------
  // debugging functions ---------------------------------------------
  // -----------------------------------------------------------------

  bool KtLists::checkddi(std::string s, KtDist_map::iterator  ddit) {
    KtJetInfo_iterator it = (*ddit).second;
    if( (*it)->pos_in_diList != ddit ) std::cout << s << " ddi Mismatch ddi D="<< (*ddit).first <<" pointing to "<<(*it)->index << "  with Dddi="<< (*(*it)->pos_in_diList).first <<std::endl;
    return ( (*it)->pos_in_diList != ddit);
  }
  void KtLists::checkddi() {
    KtDist_map::iterator it = m_diList.begin();
    KtDist_map::iterator itE = m_diList.end();
    int i = 0;
    for(; it != itE; ++it){
      if(checkddi(" global ",it)) std::cout << " pbm was at " <<i << std::endl;
      i++;
    }
  
  }
  void KtLists::checkNN() {
    KtJetInfo_iterator it = m_ktlist.begin();
    KtJetInfo_iterator itE = m_ktlist.end();
    int i = 0;
    for(; it != itE; ++it){
      if((*(*it)->closest_neighb)->index > 6000 ) std::cout << " pbm was at " << (*it)->index << std::endl;
      if((*it)->closest_neighb == it ){
	std::cout << "  !!! Equals NN  at " << (*it)->index << std::endl;
      }
      i++;
    }
    
  }
  void KtLists::dumpktlist() {
    KtJetInfo_iterator it  = m_ktlist.begin();
    KtJetInfo_iterator itE = m_ktlist.end() ;
    for( ; it != itE; ++it){
      std::cout << (*it) << "  index=" << (*it)->index << "   nn=" << (*(*it)->closest_neighb)->index << std::endl;	
    }    
  }
  void KtLists::dumpddi() {
    KtDist_map::iterator it = m_diList.begin();
    KtDist_map::iterator itE = m_diList.end();
    int i = 0;
    for(; it != itE; ++it){
      std::cout << i << "  ddi=" << (*it).first << "   index " << (*(*it).second)->index << std::endl;
      i++;
    }    
  }
  void KtLists::checkdGi() {
    KtDist_map::iterator it = m_dijList.begin();
    KtDist_map::iterator itE = m_dijList.end();
    int i = 0;
    for(; it != itE; ++it){
      KtJetInfo_iterator kit = (*it).second;
      if( (*kit)->pos_in_dijList != it ) std::cout << i << " dGi Mismatch dGi D="<< (*it).first <<" pointing to "<<(*kit)->index << "  with DGdi="<< (*(*kit)->pos_in_dijList).first << std::endl;
      i++;
    }    
  }
  float KtLists::getERemaining(){
    KtJetInfo_iterator it  = m_ktlist.begin();
    KtJetInfo_iterator itE = m_ktlist.end() ;
    float eTot =0.0;
    for( ; it != itE; ++it){
      eTot += (*it)->hlv.e();
    }
    return eTot;
  }
  void KtNNOperation::dumpUpdatelist(){
    std::list<KtJetInfo_iterator>::iterator it = m_points_toupdate.begin();
    std::list<KtJetInfo_iterator>::iterator itE = m_points_toupdate.end();
    for(; it != itE; ++it){
      KtJetInfo_iterator kit = (*it) ;
      std::cout << "      " << (*kit)->index << "  " << (*(*kit)->closest_neighb)->index << std::endl;	
    }
  }
  
  // PhiBinn-----



}  // namespace SpartyJet
}//end of namespace
