//*******************************************************************************
// Filename : JetConeFinderTool.cxx 
// Author   : Ambreesh Gupta
// Created  : Nov, 2000
//
// Jan 2004: Use CLHEP units. Use phi = (-pi,pi].
//*******************************************************************************

#include <iostream>

#include "JetConeFinderTool.h"
#include "JetCore/Jet.hh"
//#include "JetEvent/JetCollection.h"
//#include "JetUtils/JetCollectionHelper.h"
//#include "JetUtils/JetSorters.h"
#include "JetCore/JetDistances.hh"
#include "JetCore/CommonUtils.hh"


//Library Includes
#include <vector>
//#include <list>
//#include <algorithm>
#include <math.h>


//#include "CLHEP/Vector/ThreeVector.h"
//#include "CLHEP/Units/SystemOfUnits.h"

//#include "GaudiKernel/MsgStream.h"
//#include "GaudiKernel/Service.h"

namespace SpartyJet { 
// set the default energy scale
double GeV = 1000;

JetConeFinderTool::JetConeFinderTool(const std::string& name) :m_coneR(0.7)
  , m_ptcut(0.0*GeV)
  , m_eps(0.05)
  , m_seedPt(2.0*GeV)
  , m_etaMax(5.0)
{
//   declareProperty("ConeR",m_coneR);
//   declareProperty("PtCut",m_ptcut);
//   declareProperty("Epsilon",m_eps);
//   declareProperty("SeedPt",m_seedPt);
//   declareProperty("EtaMax",m_etaMax);
  m_log.set_name("JetConeFinderTool");
}

JetConeFinderTool::~JetConeFinderTool()
{}

/////////////////////////////////////////////////////////////////////////////////
//Execution                                                                     /
/////////////////////////////////////////////////////////////////////////////////
StatusCode JetConeFinderTool::execute(jetcollection_t & theJets)
{
  //StatusCode sc;
  //MsgStream log(msgSvc(), name());
  
  
  //JetCollectionHelper::sort_jets(theJets,JetSorters::sortJetByEtDown());
  sort_jet_list<JetSorter_Et>(theJets);
  //sort_list_pt(theJets);

  m_pjetV = &theJets;

  m_log  << " Total Number of input jets   = " << theJets.size() << std::endl;
  
  if(theJets.size()==0) return 0;
  Jet *j=theJets[0];
  m_log << j->pt() << "  "<< j->px() << "  "<< j->py() << "  "<<j->pz()<<"  "<< j->e() << std::endl;


  // Initiale ctr/dctr counter for object counting.
  m_ctr = 0;
  m_dctr = 0;

  //////////////////////
  // Reconstruct Jets // 
  //////////////////////
  this->reconstruct();
  //m_log <<  " Number of jets = " << m_jetOV->size() << std::endl;

  //////////////////////////
  // ReFill JetCollection //
  //////////////////////////
  //   jetcollection_t::iterator firstJet = theJets.begin();
  //   while ( firstJet != theJets.end() ) {    
  //      firstJet = JetCollectionHelper::remove_object(theJets,firstJet);
  //   }
  //   JetCollectionHelper::copy_collection(m_jetOV,theJets);
  //Jet::jet_list_t::iterator inputE = theJets.end(); inputE--;
  clear_list(theJets);
  jetcollection_t::iterator it = m_jetOV->begin();
  jetcollection_t::iterator itE = m_jetOV->end();
  for(; it!=itE; ++it){
    theJets.push_back(*it);
  }


  delete m_jetOV;
  return 1;
  //////////////////
  // Object Count //
  //////////////////
  //log << MSG::INFO << " Total Number of jets created = " << m_ctr << std::endl;
  //log << MSG::INFO << " Total Number of jets deleted = " << m_dctr << std::endl;
  //log << MSG::INFO 
  //    << " Total Number of jets recnstr = " << theJets.size() 
  //    << " Total number of objects created = " << m_ctr - m_dctr 
  //    << std::endl;
  
  /////////////////////////////////////////////////////////
  // Report log: Do not stop event loop in case of error // 
  /////////////////////////////////////////////////////////
//   if ( sc.isFailure() ) {
//     log << MSG::WARNING
//         << " Could not register Jet Container "
//         << std::endl;
//     return ( StatusCode::SUCCESS );
//   }
//   return StatusCode::SUCCESS;

}

///////////////////////////////////////////////////////////////////////////////
// Reconstruction algorithm specific methods                                  /
///////////////////////////////////////////////////////////////////////////////

void
JetConeFinderTool::reconstruct()
{
  //MsgStream mlog(msgSvc(), name());

  m_jetOV = new jetcollection_t();

  jetcollection_t::iterator tItr;
  jetcollection_t::iterator tItr_begin = m_pjetV->begin();
  jetcollection_t::iterator tItr_end   = m_pjetV->end();

  // order towers in pt

  for ( tItr=tItr_begin; tItr!=tItr_end; ++tItr ) {    

    // Seed Cut
    double tEt = (*tItr)->et();

    //m_log << " jet  " << tEt << std::endl;    
    if ( tEt < m_seedPt ) break;

    

    // Tower eta, phi
    double etaT = (*tItr)->eta();
    double phiT = (*tItr)->phi();    
    
    // Iteration logic
    bool stable = false;
    bool inGeom = true;
    
    Jet* preJet;
    
    int count = 1;
    do { // Iteration Loop

      // Make cone  
      preJet = calc_cone(etaT,phiT);
      double etaC = preJet->eta();
      double phiC = preJet->phi();
      
      double deta = fabs(etaT - etaC);
      double dphi = fabs(JetDistances::deltaPhi(phiT,phiC));

      // Is Stable ?
      if ( deta < m_eps && dphi < m_eps ) 
	stable = true;
      
      // In Geometry ?
      if ( fabs(etaC) > m_etaMax ) 
	inGeom = false;	

      etaT = etaC;
      phiT = phiC;

      if ( !stable && inGeom ) {
	delete preJet;
	m_dctr +=1;
      }
      ++count;

    }while ( !stable && inGeom && count < 10  );      
  
    if ( count > 9 && (!stable && inGeom) ) continue;  // FIXME 9 ?

    // If iteration was succesfull -- check if this is a new jet and 
    // add it to OV.

    if ( stable && inGeom ) {
      jetcollection_t::iterator pItr   = m_jetOV->begin();
      jetcollection_t::iterator pItrE  = m_jetOV->end();
    
      bool newJet = true;
      double etaT = preJet->eta();
      double phiT = preJet->phi();

      for ( ; pItr != pItrE ; ++pItr ) {
	double etaC = (*pItr)->eta();
	double phiC = (*pItr)->phi();

	double deta = fabs(etaT - etaC);
	double dphi = fabs(JetDistances::deltaPhi(phiT,phiC));

	if ( deta < 0.05  && dphi < 0.05 ) { 
	  newJet = false;
	  break;
	}
      }
      if ( newJet ) {
	m_jetOV->push_back( preJet );
      }
      else {
	delete preJet;
	m_dctr +=1;
      }
    }
    else {
      delete preJet;
      m_dctr +=1;
    }
  }    
}

Jet*
JetConeFinderTool::calc_cone(double eta, double phi)
{
  //MsgStream mlog(msgSvc(), name());

  // Create a new Jet   
  Jet* j = new Jet();
  m_ctr +=1; 

  // Add all ProtoJet within m_coneR to this Jet  
  jetcollection_t::iterator itr  = m_pjetV->begin();
  jetcollection_t::iterator itrE = m_pjetV->end();

  for ( ; itr!=itrE; ++itr ) {
    double dR = JetDistances::deltaR(eta,phi,(*itr)->eta(),(*itr)->phi());
    if ( dR < m_coneR ) {
      j->addJet( (*itr) );
    }
  }    

  return j;
}



}  // namespace SpartyJet

