//*******************************************************************************
// Filename : JetSplitMergeTool.cxx 
// Author   : Ambreesh Gupta
// Created  : Nov, 2001
//*******************************************************************************

#include <iostream>

#include "JetSplitMergeTool.h"
#include "JetCore/Jet.hh"
// #include "JetEvent/JetCollection.h"
// #include "JetUtils/JetCollectionHelper.h"
// #include "JetUtils/JetSorters.h"
// #include "JetUtils/JetDistances.h"
#include "JetCore/JetDistances.hh"
#include "JetCore/CommonUtils.hh"

//Library Includes
//#include <vector>
//#include <list>
//#include <algorithm>
//#include <math.h>
//#include "CLHEP/Vector/ThreeVector.h"

//Gaudi Includes
//#include "GaudiKernel/MsgStream.h"
//#include "GaudiKernel/Service.h"
namespace SpartyJet { 
JetSplitMergeTool::JetSplitMergeTool(const std::string& type)
  :  m_f( 0.5 )
{
  //declareProperty("OverlapFraction",m_f);
  m_log.set_name("JetSplitMergeTool");
}

JetSplitMergeTool::~JetSplitMergeTool()
{}

/////////////////////////////////////////////////////////////////////////////////
//Execution                                                                     /
/////////////////////////////////////////////////////////////////////////////////
StatusCode JetSplitMergeTool::execute( jetcollection_t* theJets )
{

  // StatusCode sc;
  // MsgStream log(msgSvc(), name());

  m_ctr = 0;
  m_dctr = 0;

  ////////////////////////////////////////////////////
  // From the input, collection create a list of Jet//
  ////////////////////////////////////////////////////
  m_preJet.clear();
  m_jet.clear();

  jetcollection_t::iterator itrB = theJets->begin();
  jetcollection_t::iterator itrE = theJets->end(); 

  //m_log  << " Total Number of input jets   = " << theJets->size() << std::endl;

  double etot =0.;
  for (;itrB!=itrE;itrB++) {
    //Jet* j = new Jet(*itrB);
    Jet* j = new Jet(); j->addJet(*itrB);
    m_ctr +=1;
    m_preJet.push_back(j);    

    etot += j->e();    
  }

  /////////////////////
  // Split Merge Jets//
  /////////////////////
  this->split_merge();
  m_log  << " Number of jets :: after SM " << m_jet.size() << std::endl;
 
  /////////////////////////////////////////////
  // Empty and re-fill input jetcollection_t //
  /////////////////////////////////////////////
//   jetcollection_t::iterator firstJet = theJets->begin();
//   while ( firstJet != theJets->end() ) {
//     firstJet = JetCollectionHelper::remove_object(theJets,firstJet);
//   }
//   JetCollectionHelper::copy_collection(m_jet,theJets);
  clear_list(*theJets);
  jetcollection_t::iterator it = m_jet.begin();
  jetcollection_t::iterator itE = m_jet.end();
  for(; it!=itE; ++it){    
    theJets->push_back(*it);
  }


  //////////////////
  // Object Count //
  //////////////////
  //m_log  << " Total Number of jets created = " << m_ctr << std::endl;
  //m_log  << " Total Number of jets deleted = " << m_dctr << std::endl;
  //m_log  << " Total Number of jets recnstr = " << theJets->size() << std::endl;

  return 1;
}

///////////////////////////////////////////////////////////////////////////////
// Reconstruction algorithm specific methods                                  /
///////////////////////////////////////////////////////////////////////////////

void
JetSplitMergeTool::split_merge()
{
  //MsgStream mlog(msgSvc(), name());

  if ( m_preJet.size() >= 2 ) {
    do {
      //m_preJet.sort( JetSorters::sortJetByEtDown() );
      sort_list_et(m_preJet);
      
      jetcollection_t::iterator itr;
      jetcollection_t::iterator first = m_preJet.begin();
      jetcollection_t::iterator last  = m_preJet.end();
      
      itr=first;
      ++itr;
      bool overlap = false;
  
      for (;itr != last;++itr) {      
	double etaF = (*first)->eta();
	double phiF = (*first)->phi();
	double etaS = (*itr)->eta();
	double phiS = (*itr)->phi();
	
	//Jet* oJet = (*first)->getOverlap(**itr);   
	Jet* oJet = jet_from_overlap( (*first),*itr);   
	m_ctr +=1; 

	Jet::constit_vect_t::iterator itro  = oJet->firstConstituent();
	Jet::constit_vect_t::iterator itroE = oJet->lastConstituent();
	
	//if ( oJet->size() != 0 ) {
	//m_log <<  "   --  "<< oJet->getConstituentNum() << std::endl;
	if ( oJet->getConstituentNum() != 0 ) {
	  overlap = true;
	  
	  // fraction
	  double f = sqrt(pow(oJet->px(),2)+pow(oJet->py(),2))/
	    sqrt(pow((*itr)->px(),2)+pow((*itr)->py(),2));
	  
	  // merge
	  if ( f > m_f) {
	    // we need to remove constituents !
	    Jet *j = (*first);
	    for ( ;itro != itroE; ++itro ) j->removeConstituent(*itro);
	    (*first)->addJet(*itr);
	    //m_preJet.remove(*itr);
	    delete *itr;
	    m_preJet.erase(itr);
	    m_dctr +=1;
	  }	
	  
	  // split	
	  if ( f <= m_f) {	  
	    for ( ;itro != itroE; ++itro ) {	      
	      // Distance of first jet from ProtoJet
	      double deta1 = etaF - (*itro)->eta();
	      double dphi1 = fabs(JetDistances::deltaPhi(phiF,(*itro)->phi()));
	      double dist1 = pow( deta1 , 2 ) + pow( dphi1 , 2 );
	      
	      // Distance of second jet from ProtoJet
	      double deta2 = etaS - (*itro)->eta();
	      double dphi2 = fabs(JetDistances::deltaPhi(phiS,(*itro)->phi()));
	      double dist2 = pow( deta2 , 2 ) + pow( dphi2 , 2 );
	      
	      // Remove protojet from farther Jet	    	      
	      if ( dist1 > dist2 ) (*first)->removeConstituent(*itro);
	      if ( dist1 <= dist2 ) (*itr)->removeConstituent(*itro);	
	    }
	  }
	  // Delete overlap jet     
	  delete oJet;     
	  m_dctr +=1;
	  break; 
	}  
	else {
	  // Delete overlap jet     
	  delete oJet;     
	  m_dctr +=1;
	}    
      }
      
      if ( overlap == false ) {
	m_jet.push_back(*first);
	//m_preJet.remove(*first);      
	m_preJet.erase(first);      
      }
      
    } while ( m_preJet.size() != 0 );    
  }
  else if ( m_preJet.size() == 1) {
    m_jet.push_back( *(m_preJet.begin()) );
  }

}

//////////////////////////////////////////////////////////////////////

// "True" eta and phi ASSUMING the 4-vector is filled as
// ex -> e * sin(theta) * cos(phi)
// ey -> e * sin(theta) * sin(phi)
// ez -> e * cos(theta)
// e  -> e 
// Jet phi range is (-pi,pi].


double JetSplitMergeTool::etaTrue(Jet::constit_vect_t::iterator pj)
{
  double s = ((*pj)->e() > 0) ? +1.0 : -1.0;
  double px = (*pj)->px();
  double py = (*pj)->py();
  double pz = (*pj)->pz();
  double theta = acos(pz*s/sqrt(px*px+py*py+pz*pz));
  return -log(tan(theta/2.0));
}

double JetSplitMergeTool::phiTrue(Jet::constit_vect_t::iterator pj)
{
  double s = ((*pj)->e() > 0) ? +1.0 : -1.0;
  double px = (*pj)->px();
  double py = (*pj)->py();
  return atan2(py*s,px*s);
}
}  // namespace SpartyJet

